/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard;

import java.util.Date;
import org.hswebframework.utils.time.DateFormatter;
import org.jetlinks.community.dashboard.MeasurementValue;

public class SimpleMeasurementValue
implements MeasurementValue {
    private Object value;
    private String timeString;
    private long timestamp;

    public static SimpleMeasurementValue of(Object value, Date time) {
        return SimpleMeasurementValue.of(value, DateFormatter.toString((Date)time, (String)"yyyy-MM-dd HH:mm:ss"), time.getTime());
    }

    public static SimpleMeasurementValue of(Object value, long time) {
        return SimpleMeasurementValue.of(value, new Date(time));
    }

    public static SimpleMeasurementValueBuilder builder() {
        return new SimpleMeasurementValueBuilder();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getTimeString() {
        return this.timeString;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void setTimeString(String timeString) {
        this.timeString = timeString;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    private SimpleMeasurementValue(Object value, String timeString, long timestamp) {
        this.value = value;
        this.timeString = timeString;
        this.timestamp = timestamp;
    }

    public static SimpleMeasurementValue of(Object value, String timeString, long timestamp) {
        return new SimpleMeasurementValue(value, timeString, timestamp);
    }

    public SimpleMeasurementValue() {
    }

    public static class SimpleMeasurementValueBuilder {
        private Object value;
        private String timeString;
        private long timestamp;

        SimpleMeasurementValueBuilder() {
        }

        public SimpleMeasurementValueBuilder value(Object value) {
            this.value = value;
            return this;
        }

        public SimpleMeasurementValueBuilder timeString(String timeString) {
            this.timeString = timeString;
            return this;
        }

        public SimpleMeasurementValueBuilder timestamp(long timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public SimpleMeasurementValue build() {
            return new SimpleMeasurementValue(this.value, this.timeString, this.timestamp);
        }

        public String toString() {
            return "SimpleMeasurementValue.SimpleMeasurementValueBuilder(value=" + this.value + ", timeString=" + this.timeString + ", timestamp=" + this.timestamp + ")";
        }
    }
}

