/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.measurements.sys;

import io.swagger.v3.oas.annotations.media.Schema;
import org.jetlinks.community.dashboard.measurements.sys.MonitorInfo;
import org.jetlinks.community.dashboard.measurements.sys.MonitorUtils;

public class DiskInfo
implements MonitorInfo<DiskInfo> {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u78c1\u76d8\u603b\u5bb9\u91cf,\u5355\u4f4dMB")
    private long total;
    @Schema(description="\u78c1\u76d8\u53ef\u7528\u5bb9\u91cf,\u5355\u4f4dMB")
    private long free;

    public float getUsage() {
        return MonitorUtils.round((float)(this.total - this.free) / (float)this.total * 100.0f);
    }

    @Override
    public DiskInfo add(DiskInfo info) {
        return new DiskInfo(info.total + this.total, info.free + this.free);
    }

    @Override
    public DiskInfo division(int num) {
        return new DiskInfo(this.total / (long)num, this.free / (long)num);
    }

    public long getTotal() {
        return this.total;
    }

    public long getFree() {
        return this.free;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setFree(long free) {
        this.free = free;
    }

    public String toString() {
        return "DiskInfo(total=" + this.getTotal() + ", free=" + this.getFree() + ")";
    }

    public DiskInfo(long total, long free) {
        this.total = total;
        this.free = free;
    }

    public DiskInfo() {
    }
}

