/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.supports;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetlinks.community.dashboard.Dashboard;
import org.jetlinks.community.dashboard.DashboardDefinition;
import org.jetlinks.community.dashboard.DashboardObject;
import org.jetlinks.community.dashboard.supports.CompositeDashboardObject;
import org.jetlinks.community.dashboard.supports.MeasurementProvider;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class CompositeDashboard
implements Dashboard {
    private DashboardDefinition definition;
    private Map<String, DashboardObject> staticObjects = new ConcurrentHashMap<String, DashboardObject>();
    private List<Dashboard> staticDashboard = new CopyOnWriteArrayList<Dashboard>();

    public CompositeDashboard(DashboardDefinition definition) {
        this.definition = definition;
    }

    public void addProvider(MeasurementProvider provider) {
        DashboardObject object = this.staticObjects.computeIfAbsent(provider.getObjectDefinition().getId(), __ -> new CompositeDashboardObject());
        if (object instanceof CompositeDashboardObject) {
            CompositeDashboardObject compose = (CompositeDashboardObject)object;
            compose.addProvider(provider);
        }
    }

    public void addDashboard(Dashboard dashboard) {
        this.staticDashboard.add(dashboard);
    }

    public void addObject(DashboardObject object) {
        this.staticObjects.put(object.getDefinition().getId(), object);
    }

    @Override
    public Flux<DashboardObject> getObjects() {
        return Flux.concat((Publisher[])new Publisher[]{Flux.fromIterable(this.staticObjects.values()), Flux.fromIterable(this.staticDashboard).flatMap(Dashboard::getObjects)});
    }

    @Override
    public Mono<DashboardObject> getObject(String id) {
        return Mono.justOrEmpty((Object)this.staticObjects.get(id)).switchIfEmpty(Mono.defer(() -> Flux.fromIterable(this.staticDashboard).flatMap(dashboard -> dashboard.getObject(id)).next()));
    }

    @Override
    public DashboardDefinition getDefinition() {
        return this.definition;
    }
}

