/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.redis;

import io.netty.util.concurrent.FastThreadLocal;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.jetlinks.community.codec.Serializers;
import org.jetlinks.core.utils.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class ObjectRedisSerializer
implements RedisSerializer<Object> {
    private static final Logger log = LoggerFactory.getLogger(ObjectRedisSerializer.class);
    static final FastThreadLocal<ByteArrayOutputStream> STREAM_LOCAL = new FastThreadLocal<ByteArrayOutputStream>(){

        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream(1024){

                @Override
                public void close() {
                    this.reset();
                }
            };
        }
    };

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] serialize(Object o) throws SerializationException {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream arr = (ByteArrayOutputStream)STREAM_LOCAL.get();
        try (ObjectOutput output = Serializers.getDefault().createOutput((OutputStream)arr);){
            SerializeUtils.writeObject((Object)o, (ObjectOutput)output);
            output.flush();
            byte[] byArray = arr.toByteArray();
            return byArray;
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
            throw e;
        }
    }

    /*
     * Exception decompiling
     */
    public Object deserialize(byte[] bytes) throws SerializationException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

