/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.device;

import java.io.File;
import java.time.Duration;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.h2.mvstore.MVMap;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.MVStoreException;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.jetlinks.community.configure.cluster.Cluster;
import org.jetlinks.community.configure.device.PersistentSessionEntity;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.session.DeviceSessionEvent;
import org.jetlinks.core.rpc.RpcManager;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.server.session.PersistentSession;
import org.jetlinks.supports.device.session.AbstractDeviceSessionManager;
import org.jetlinks.supports.device.session.ClusterDeviceSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.CommandLineRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.util.Lazy;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PersistenceDeviceSessionManager
extends ClusterDeviceSessionManager
implements CommandLineRunner,
ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(PersistenceDeviceSessionManager.class);
    private Supplier<DeviceRegistry> registry;
    private MVMap<String, PersistentSessionEntity> repository;
    private String filePath;
    private Duration flushInterval = Duration.ofMinutes(10L);

    public PersistenceDeviceSessionManager(RpcManager rpcManager) {
        super(rpcManager);
    }

    static MVMap<String, PersistentSessionEntity> initStore(String file) {
        File f = new File(file);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        Supplier<MVMap> builder = () -> {
            MVStore store = new MVStore.Builder().fileName(file).cacheSize(1).open();
            return store.openMap("device-session");
        };
        try {
            return builder.get();
        }
        catch (MVStoreException e) {
            log.warn("load session from {} error,delete it and init.", (Object)file, (Object)e);
            f.delete();
            return builder.get();
        }
    }

    public void init() {
        super.init();
        if (this.filePath == null) {
            this.filePath = "./data/sessions-" + Cluster.id().replace(":", "_").replace("/", "");
        }
        this.repository = PersistenceDeviceSessionManager.initStore(this.filePath);
        if (!this.flushInterval.isZero() && !this.flushInterval.isNegative()) {
            this.disposable.add(Flux.interval((Duration)this.flushInterval).onBackpressureDrop().concatMap(ignore -> (Mono)Flux.fromIterable(this.localSessions.values()).mapNotNull(ref -> {
                if (ref.loaded != null && ref.loaded.isWrapFrom(PersistentSession.class)) {
                    return (PersistentSession)ref.loaded.unwrap(PersistentSession.class);
                }
                return null;
            }).as(this::tryPersistent), 1).subscribe());
        }
        this.disposable.add(this.listenEvent(event -> {
            if (event.getType() == DeviceSessionEvent.Type.unregister && event.getSession().isWrapFrom(PersistentSession.class)) {
                return this.removePersistentSession((PersistentSession)event.getSession().unwrap(PersistentSession.class));
            }
            return Mono.empty();
        }));
    }

    public void shutdown() {
        super.shutdown();
        ((Mono)Flux.fromIterable(this.localSessions.values()).filter(ref -> ref.loaded != null).filter(ref -> ref.loaded.isWrapFrom(PersistentSession.class)).map(ref -> (PersistentSession)ref.loaded.unwrap(PersistentSession.class)).as(this::tryPersistent)).block();
        this.repository.store.compactMoveChunks();
        this.repository.store.close();
    }

    protected Mono<DeviceSession> handleSessionCompute(DeviceSession old, DeviceSession newSession) {
        if (old == newSession) {
            return Mono.just((Object)newSession);
        }
        if ((old == null || !old.isWrapFrom(PersistentSession.class)) && newSession.isWrapFrom(PersistentSession.class)) {
            return this.tryPersistent((Flux<PersistentSession>)Flux.just((Object)newSession.unwrap(PersistentSession.class))).thenReturn((Object)newSession);
        }
        return super.handleSessionCompute(old, newSession);
    }

    Mono<Void> tryPersistent(Flux<PersistentSession> sessions) {
        return sessions.flatMap(session -> PersistentSessionEntity.from(this.getCurrentServerId(), session, this.registry.get())).distinct(GenericEntity::getId).doOnNext(e -> {
            log.debug("persistent device[{}] session", (Object)e.getDeviceId());
            this.repository.put((Object)e.getDeviceId(), (Object)e);
        }).onErrorResume(err -> {
            log.warn("persistent session error", err);
            return Mono.empty();
        }).then();
    }

    Mono<Void> resumeSession(PersistentSessionEntity entity) {
        return entity.toSession(this.registry.get()).doOnNext(session -> {
            log.debug("resume session[{}]", (Object)session.getDeviceId());
            this.localSessions.putIfAbsent(session.getDeviceId(), new AbstractDeviceSessionManager.DeviceSessionRef(session.getDeviceId(), (AbstractDeviceSessionManager)this, (DeviceSession)session));
        }).onErrorResume(err -> {
            log.debug("resume session[{}] error", (Object)entity.getDeviceId(), err);
            return Mono.empty();
        }).then();
    }

    Mono<Void> removePersistentSession(PersistentSession session) {
        this.repository.remove((Object)session.getId());
        return Mono.empty();
    }

    public void run(String ... args) throws Exception {
        Flux.fromIterable((Iterable)this.repository.values()).flatMap(this::resumeSession).subscribe();
    }

    public void setApplicationContext(@Nonnull ApplicationContext applicationContext) throws BeansException {
        this.registry = Lazy.of(() -> (DeviceRegistry)applicationContext.getBean(DeviceRegistry.class));
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Duration getFlushInterval() {
        return this.flushInterval;
    }

    public void setFlushInterval(Duration flushInterval) {
        this.flushInterval = flushInterval;
    }
}

