/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.configure.trace;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.jetlinks.core.utils.StringBuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LoggingSpanExporter
implements SpanExporter {
    private final Logger logger;

    public static LoggingSpanExporter create(String name) {
        return new LoggingSpanExporter(LoggerFactory.getLogger((String)name));
    }

    public CompletableResultCode export(@Nonnull Collection<SpanData> spans) {
        if (!this.logger.isTraceEnabled()) {
            return CompletableResultCode.ofSuccess();
        }
        for (SpanData span : spans) {
            String log = StringBuilderUtils.buildString((Object)span, (data, sb) -> {
                InstrumentationLibraryInfo instrumentationLibraryInfo = data.getInstrumentationLibraryInfo();
                sb.append("'").append(data.getName()).append("' : ").append(data.getTraceId()).append(" ").append(data.getSpanId()).append(" ").append(data.getKind()).append(" [tracer: ").append(instrumentationLibraryInfo.getName()).append(":").append(instrumentationLibraryInfo.getVersion() == null ? "" : instrumentationLibraryInfo.getVersion()).append("] ").append(data.getAttributes());
            });
            this.logger.trace(log);
        }
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        return this.flush();
    }

    public LoggingSpanExporter(Logger logger) {
        this.logger = logger;
    }
}

