/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.utils;

import java.math.BigDecimal;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.jetlinks.community.utils.DateMathParser;
import org.jetlinks.reactor.ql.utils.CastUtils;
import reactor.core.publisher.Flux;

public class TimeUtils {
    public static Duration parse(String timeString) {
        char[] all = timeString.toCharArray();
        if (all[0] == 'P' || all[0] == '-' && all[1] == 'P') {
            return Duration.parse(timeString);
        }
        Duration duration = Duration.ofSeconds(0L);
        char[] tmp = new char[32];
        int numIndex = 0;
        for (char c : all) {
            if (c == '-' || c >= '0' && c <= '9') {
                tmp[numIndex++] = c;
                continue;
            }
            long val = new BigDecimal(tmp, 0, numIndex).longValue();
            numIndex = 0;
            Duration plus = null;
            if (c == 'D' || c == 'd') {
                plus = Duration.ofDays(val);
            } else if (c == 'H' || c == 'h') {
                plus = Duration.ofHours(val);
            } else if (c == 'M' || c == 'm') {
                plus = Duration.ofMinutes(val);
            } else if (c == 's') {
                plus = Duration.ofSeconds(val);
            } else if (c == 'S') {
                plus = Duration.ofMillis(val);
            } else if (c == 'W' || c == 'w') {
                plus = Duration.ofDays(val * 7L);
            }
            if (plus == null) continue;
            duration = duration.plus(plus);
        }
        if (numIndex != 0) {
            duration = duration.plus(Duration.ofMillis(new BigDecimal(tmp, 0, numIndex).longValue()));
        }
        return duration;
    }

    public static ChronoUnit parseUnit(String expr) {
        if ((expr = expr.toUpperCase()).equals("MILLENNIA")) {
            return ChronoUnit.MILLENNIA;
        }
        if (expr.equals("FOREVER")) {
            return ChronoUnit.FOREVER;
        }
        if (!expr.endsWith("S")) {
            expr = expr + "S";
        }
        return ChronoUnit.valueOf(expr);
    }

    public static Date parseDate(String expr) {
        return new Date(DateMathParser.parse(expr, System::currentTimeMillis));
    }

    public static Date convertToDate(Object obj) {
        if (obj instanceof String) {
            return new Date(DateMathParser.parse(String.valueOf(obj), System::currentTimeMillis));
        }
        return CastUtils.castDate((Object)obj);
    }

    public static long round(long ts, long interval) {
        return ts / interval * interval;
    }

    public static Flux<Long> parseIntervalRange(long from, long to, long interval) {
        return Flux.create(sink -> {
            long _from = from;
            long _to = to;
            if (_from > _to) {
                _from = to;
                _to = from;
            }
            _from = TimeUtils.round(_from, interval);
            _to = TimeUtils.round(_to, interval);
            sink.next((Object)_from);
            while (_from < _to && !sink.isCancelled()) {
                sink.next((Object)(_from += interval));
            }
            sink.complete();
        });
    }
}

