/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.utils;

import java.util.function.Supplier;
import org.jetlinks.community.utils.TimeUtils;

public class SystemUtils {
    static float memoryWatermark = Float.parseFloat(System.getProperty("memory.watermark", System.getProperty("memory.waterline", "0.1")));
    static long memoryWatermarkDuration = TimeUtils.parse(System.getProperty("memory.watermark.duration", "5s")).toMillis();
    static long errorPintInterval = TimeUtils.parse(System.getProperty("memory.watermark.duration", "500")).toMillis();
    static Supplier<Float> memoryRemainderSupplier = () -> {
        Runtime rt = Runtime.getRuntime();
        long free = rt.freeMemory();
        long total = rt.totalMemory();
        long max = rt.maxMemory();
        return Float.valueOf((float)(max - total + free) / ((float)max + 0.0f));
    };
    private static volatile long outTimes = 0L;
    private static volatile long lastPrintTime = 0L;

    public static float getMemoryRemainder() {
        return memoryRemainderSupplier.get().floatValue();
    }

    public static boolean memoryIsOutOfWatermark() {
        boolean out;
        boolean bl = out = SystemUtils.getMemoryRemainder() < memoryWatermark;
        if (!out) {
            outTimes = 0L;
            return false;
        }
        if (outTimes == 0L) {
            outTimes = System.currentTimeMillis();
        } else if (System.currentTimeMillis() - outTimes > memoryWatermarkDuration) {
            System.gc();
            return true;
        }
        return false;
    }

    public static void printError(String format, Object ... args) {
        SystemUtils.printError(format, () -> args);
    }

    public static void printError(String format, Supplier<Object[]> argSupplier) {
        long now = System.currentTimeMillis();
        if (now - lastPrintTime > errorPintInterval) {
            lastPrintTime = now;
            System.err.printf(format + "%n", argSupplier.get());
        }
    }
}

