/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.utils;

import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAdjusters;
import java.util.function.LongSupplier;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.springframework.util.StringUtils;

public class DateMathParser {
    public static long parse(String text, LongSupplier now) {
        String mathString;
        long time;
        if (text.startsWith("now()")) {
            time = now.getAsLong();
            mathString = text.substring("now()".length());
        } else if (text.startsWith("now")) {
            time = now.getAsLong();
            mathString = text.substring("now".length());
        } else {
            int index = text.indexOf("||");
            if (index == -1) {
                return DateMathParser.parseDateTime(text);
            }
            time = DateMathParser.parseDateTime(text.substring(0, index));
            mathString = text.substring(index + 2);
        }
        return DateMathParser.parseMath(mathString, time);
    }

    private static long parseMath(String mathString, long time) {
        ZonedDateTime dateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), ZoneId.systemDefault());
        int i = 0;
        block9: while (i < mathString.length()) {
            int num;
            int sign;
            boolean round;
            char c;
            if ((c = mathString.charAt(i++)) == '/') {
                round = true;
                sign = 1;
            } else {
                round = false;
                if (c == '+') {
                    sign = 1;
                } else if (c == '-') {
                    sign = -1;
                } else {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + mathString);
                }
            }
            if (i >= mathString.length()) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + mathString);
            }
            if (!Character.isDigit(mathString.charAt(i))) {
                num = 1;
            } else {
                int numFrom = i;
                while (i < mathString.length() && Character.isDigit(mathString.charAt(i))) {
                    ++i;
                }
                if (i >= mathString.length()) {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + mathString);
                }
                num = Integer.parseInt(mathString.substring(numFrom, i));
            }
            if (round && num != 1) {
                throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + mathString);
            }
            char unit = mathString.charAt(i++);
            switch (unit) {
                case 'y': {
                    if (round) {
                        dateTime = dateTime.withDayOfYear(1).with(LocalTime.MIN);
                        continue block9;
                    }
                    dateTime = dateTime.plusYears(sign * num);
                    continue block9;
                }
                case 'M': {
                    if (round) {
                        dateTime = dateTime.withDayOfMonth(1).with(LocalTime.MIN);
                        continue block9;
                    }
                    dateTime = dateTime.plusMonths(sign * num);
                    continue block9;
                }
                case 'w': {
                    if (round) {
                        dateTime = dateTime.with(TemporalAdjusters.previousOrSame(DayOfWeek.MONDAY)).with(LocalTime.MIN);
                        continue block9;
                    }
                    dateTime = dateTime.plusWeeks(sign * num);
                    continue block9;
                }
                case 'd': {
                    if (round) {
                        dateTime = dateTime.with(LocalTime.MIN);
                        continue block9;
                    }
                    dateTime = dateTime.plusDays(sign * num);
                    continue block9;
                }
                case 'H': 
                case 'h': {
                    if (round) {
                        dateTime = dateTime.withMinute(0).withSecond(0).withNano(0);
                        continue block9;
                    }
                    dateTime = dateTime.plusHours(sign * num);
                    continue block9;
                }
                case 'm': {
                    if (round) {
                        dateTime = dateTime.withSecond(0).withNano(0);
                        continue block9;
                    }
                    dateTime = dateTime.plusMinutes(sign * num);
                    continue block9;
                }
                case 's': {
                    if (round) {
                        dateTime = dateTime.withNano(0);
                        continue block9;
                    }
                    dateTime = dateTime.plusSeconds(sign * num);
                    continue block9;
                }
            }
            throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u8868\u8fbe\u5f0f:" + mathString);
        }
        return dateTime.toInstant().toEpochMilli();
    }

    private static long parseDateTime(String value) {
        if (StringUtils.isEmpty((Object)value)) {
            throw new IllegalArgumentException("cannot parse empty date");
        }
        return DateTimeType.GLOBAL.convert((Object)value).getTime();
    }
}

