/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.reactorql.term;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetlinks.community.reactorql.term.FixedTermTypeSupport;
import org.jetlinks.community.reactorql.term.TermType;
import org.jetlinks.community.reactorql.term.TermTypeSupport;
import org.jetlinks.core.metadata.DataType;

public class TermTypes {
    private static final Map<String, TermTypeSupport> supports = new LinkedHashMap<String, TermTypeSupport>();

    public static void register(TermTypeSupport support) {
        supports.put(support.getType(), support);
    }

    public static List<TermType> lookup(DataType dataType) {
        return supports.values().stream().filter(support -> support.isSupported(dataType)).map(TermTypeSupport::type).collect(Collectors.toList());
    }

    public static Optional<TermTypeSupport> lookupSupport(String type) {
        return Optional.ofNullable(supports.get(type));
    }

    static {
        for (FixedTermTypeSupport value : FixedTermTypeSupport.values()) {
            TermTypes.register(value);
        }
    }
}

