/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.web;

import com.fasterxml.jackson.databind.JsonMappingException;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.ezorm.core.meta.AbstractColumnMetadata;
import org.hswebframework.ezorm.rdb.exception.DuplicateKeyException;
import org.hswebframework.web.crud.web.ResponseMessage;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.reference.DataReferenceInfo;
import org.jetlinks.community.reference.DataReferencedException;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.exception.DeviceOperationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.core.codec.DecodingException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import reactor.core.publisher.Mono;

@RestControllerAdvice
@Order(value=-2147483648)
public class ErrorControllerAdvice {
    private static final Logger log = LoggerFactory.getLogger(ErrorControllerAdvice.class);

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<?>> handleException(DecodingException decodingException) {
        Throwable cause = decodingException.getCause();
        if (cause != null) {
            if (cause instanceof JsonMappingException) {
                return this.handleException((JsonMappingException)cause);
            }
            return Mono.just((Object)ResponseMessage.error((int)400, (String)"illegal_argument", (String)cause.getMessage()));
        }
        return Mono.just((Object)ResponseMessage.error((int)400, (String)"illegal_argument", (String)decodingException.getMessage()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<?>> handleException(JsonMappingException decodingException) {
        Throwable cause = decodingException.getCause();
        if (cause != null) {
            if (cause instanceof IllegalArgumentException) {
                return Mono.just((Object)ResponseMessage.error((int)400, (String)"illegal_argument", (String)cause.getMessage()));
            }
            return Mono.just((Object)ResponseMessage.error((int)400, (String)"illegal_argument", (String)cause.getMessage()));
        }
        return Mono.just((Object)ResponseMessage.error((int)400, (String)"illegal_argument", (String)decodingException.getMessage()));
    }

    @ExceptionHandler
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public Mono<ResponseMessage<?>> handleException(DuplicateKeyException e) {
        List columns = e.getColumns().stream().map(AbstractColumnMetadata::getAlias).collect(Collectors.toList());
        if (columns.isEmpty()) {
            return LocaleUtils.resolveMessageReactive((String)"error.duplicate_key", (Object[])new Object[0]).map(msg -> ResponseMessage.error((int)400, (String)"duplicate_key", (String)msg));
        }
        return LocaleUtils.resolveMessageReactive((String)"error.duplicate_key_detail", (Object[])new Object[]{columns}).map(msg -> ResponseMessage.error((int)400, (String)"duplicate_key", (String)msg).result((Object)columns));
    }

    @ExceptionHandler
    public Mono<ResponseEntity<ResponseMessage<Object>>> handleException(DeviceOperationException e) {
        if (e.getCode() == ErrorCode.REQUEST_HANDLING) {
            return LocaleUtils.resolveMessageReactive((String)"message.device_message_handing", (Object[])new Object[0]).map(msg -> ResponseEntity.status((HttpStatus)HttpStatus.OK).body((Object)ResponseMessage.error((int)200, (String)"request_handling", (String)msg).result(msg)));
        }
        HttpStatus _status = HttpStatus.INTERNAL_SERVER_ERROR;
        if (e.getCode() == ErrorCode.FUNCTION_UNDEFINED || e.getCode() == ErrorCode.PARAMETER_UNDEFINED) {
            _status = HttpStatus.NOT_FOUND;
        } else if (e.getCode() == ErrorCode.PARAMETER_UNDEFINED) {
            _status = HttpStatus.BAD_REQUEST;
        }
        HttpStatus status = _status;
        return LocaleUtils.resolveMessageReactive((String)e.getCode().getText(), (Object[])new Object[0]).map(msg -> ResponseEntity.status((HttpStatus)status).body((Object)ResponseMessage.error((int)status.value(), (String)e.getCode().name().toLowerCase(), (String)msg)));
    }

    @ExceptionHandler
    public Mono<ResponseMessage<List<DataReferenceInfo>>> handleException(DataReferencedException e) {
        return e.getLocalizedMessageReactive().map(msg -> ResponseMessage.error((int)400, (String)"error.data.referenced", (String)msg).result(e.getReferenceList()));
    }
}

