/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.resource;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetlinks.community.resource.Resource;
import org.jetlinks.community.resource.ResourceProvider;
import org.jetlinks.community.resource.SimpleResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public abstract class ClassPathJsonResourceProvider
implements ResourceProvider {
    private static final Logger log = LoggerFactory.getLogger(ClassPathJsonResourceProvider.class);
    private final String type;
    private final String filePath;
    private static final ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private List<Resource> cache;

    public ClassPathJsonResourceProvider(String type, String filePath) {
        this.type = type;
        this.filePath = filePath;
    }

    @Override
    public final Flux<Resource> getResources() {
        return Flux.fromIterable(this.cache == null ? (this.cache = this.read()) : this.cache);
    }

    @Override
    public final Flux<Resource> getResources(Collection<String> id) {
        HashSet<String> filter = new HashSet<String>(id);
        return this.getResources().filter(res -> filter.contains(res.getId()));
    }

    private List<Resource> read() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            log.debug("start load {} resource [{}]", (Object)this.type, (Object)this.filePath);
            for (org.springframework.core.io.Resource resource : resourcePatternResolver.getResources(this.filePath)) {
                log.debug("loading {} resource {}", (Object)this.type, (Object)resource);
                try (InputStream inputStream = resource.getInputStream();){
                    int index = 0;
                    for (JSONObject json : JSON.parseArray((String)StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8), JSONObject.class)) {
                        ++index;
                        String id = this.getResourceId(json);
                        if (StringUtils.hasText((String)id)) {
                            resources.add(SimpleResource.of(id, this.type, json.toJSONString()));
                            continue;
                        }
                        log.warn("{} resource [{}] id (index:{}) is empty : {}", new Object[]{this.type, resource, index, json});
                    }
                }
                catch (Throwable err) {
                    log.debug("load {} resource {} error", new Object[]{this.type, resource, err});
                }
            }
        }
        catch (Throwable e) {
            log.warn("load {} resource [{}] error", new Object[]{this.type, this.filePath, e});
            return Collections.emptyList();
        }
        return resources;
    }

    protected String getResourceId(JSONObject data) {
        return data.getString("id");
    }

    @Override
    public String getType() {
        return this.type;
    }
}

