/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.buffer;

import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import org.jetlinks.community.buffer.BufferProperties;
import org.jetlinks.community.utils.ErrorUtils;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.dao.QueryTimeoutException;
import org.springframework.transaction.CannotCreateTransactionException;

public class BufferSettings {
    private static final Predicate<Throwable> DEFAULT_RETRY_WHEN_ERROR = e -> ErrorUtils.hasException(e, IOException.class, TimeoutException.class, DataAccessResourceFailureException.class, CannotCreateTransactionException.class, QueryTimeoutException.class);
    private final String filePath;
    private final String fileName;
    private final Predicate<Throwable> retryWhenError;
    private final int bufferSize;
    private final Duration bufferTimeout;
    private final int parallelism;
    private final long maxRetryTimes;

    public static Predicate<Throwable> defaultRetryWhenError() {
        return DEFAULT_RETRY_WHEN_ERROR;
    }

    public static BufferSettings create(String filePath, String fileName) {
        return new BufferSettings(filePath, fileName, BufferSettings.defaultRetryWhenError(), 1000, Duration.ofSeconds(1L), Math.max(1, Runtime.getRuntime().availableProcessors() / 2), 5L);
    }

    public static BufferSettings create(BufferProperties properties) {
        return BufferSettings.create("buffer.queue", properties);
    }

    public static BufferSettings create(String fileName, BufferProperties properties) {
        return BufferSettings.create(properties.getFilePath(), fileName).properties(properties);
    }

    public BufferSettings bufferSize(int bufferSize) {
        return new BufferSettings(this.filePath, this.fileName, this.retryWhenError, bufferSize, this.bufferTimeout, this.parallelism, this.maxRetryTimes);
    }

    public BufferSettings bufferTimeout(Duration bufferTimeout) {
        return new BufferSettings(this.filePath, this.fileName, this.retryWhenError, this.bufferSize, bufferTimeout, this.parallelism, this.maxRetryTimes);
    }

    public BufferSettings parallelism(int parallelism) {
        return new BufferSettings(this.filePath, this.fileName, this.retryWhenError, this.bufferSize, this.bufferTimeout, parallelism, this.maxRetryTimes);
    }

    public BufferSettings maxRetry(int maxRetryTimes) {
        return new BufferSettings(this.filePath, this.fileName, this.retryWhenError, this.bufferSize, this.bufferTimeout, this.parallelism, maxRetryTimes);
    }

    public BufferSettings retryWhenError(Predicate<Throwable> retryWhenError) {
        return new BufferSettings(this.filePath, this.fileName, Objects.requireNonNull(retryWhenError), this.bufferSize, this.bufferTimeout, this.parallelism, this.maxRetryTimes);
    }

    public BufferSettings properties(BufferProperties properties) {
        return new BufferSettings(this.filePath, this.fileName, Objects.requireNonNull(this.retryWhenError), properties.getSize(), properties.getTimeout(), properties.getParallelism(), properties.getMaxRetryTimes());
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Predicate<Throwable> getRetryWhenError() {
        return this.retryWhenError;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public Duration getBufferTimeout() {
        return this.bufferTimeout;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public long getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public BufferSettings(String filePath, String fileName, Predicate<Throwable> retryWhenError, int bufferSize, Duration bufferTimeout, int parallelism, long maxRetryTimes) {
        this.filePath = filePath;
        this.fileName = fileName;
        this.retryWhenError = retryWhenError;
        this.bufferSize = bufferSize;
        this.bufferTimeout = bufferTimeout;
        this.parallelism = parallelism;
        this.maxRetryTimes = maxRetryTimes;
    }
}

