/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community;

import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.Interval;
import org.jetlinks.community.utils.TimeUtils;
import org.springframework.util.StringUtils;

public interface ValueObject {
    public Map<String, Object> values();

    default public Optional<Object> get(String name) {
        return Optional.ofNullable(this.values()).map(map -> map.get(name));
    }

    default public Optional<Integer> getInt(String name) {
        return this.get(name, Integer.class);
    }

    default public int getInt(String name, int defaultValue) {
        return this.getInt(name).orElse(defaultValue);
    }

    default public Optional<Long> getLong(String name) {
        return this.get(name, Long.class);
    }

    default public long getLong(String name, long defaultValue) {
        return this.getLong(name).orElse(defaultValue);
    }

    default public Optional<Duration> getDuration(String name) {
        return this.getString(name).map(TimeUtils::parse);
    }

    default public Optional<Interval> getInterval(String name) {
        return this.getString(name).map(Interval::of);
    }

    default public Interval getInterval(String name, Interval defaultValue) {
        return this.getString(name).map(Interval::of).orElse(defaultValue);
    }

    default public Duration getDuration(String name, Duration defaultValue) {
        return this.getDuration(name).orElse(defaultValue);
    }

    default public Optional<Date> getDate(String name) {
        return this.get(name).map(String::valueOf).map(TimeUtils::parseDate);
    }

    default public Date getDate(String name, Date defaultValue) {
        return this.getDate(name).orElse(defaultValue);
    }

    default public Optional<Double> getDouble(String name) {
        return this.get(name, Double.class);
    }

    default public double getDouble(String name, double defaultValue) {
        return this.getDouble(name).orElse(defaultValue);
    }

    default public Optional<String> getString(String name) {
        return this.get(name, String.class).filter(StringUtils::hasText);
    }

    default public String getString(String name, String defaultValue) {
        return this.getString(name).orElse(defaultValue);
    }

    default public Optional<Boolean> getBoolean(String name) {
        return this.get(name, Boolean.class);
    }

    default public boolean getBoolean(String name, boolean defaultValue) {
        return this.getBoolean(name).orElse(defaultValue);
    }

    default public <T> Optional<T> get(String name, Class<T> type) {
        return this.get(name).map(obj -> FastBeanCopier.DEFAULT_CONVERT.convert(obj, type, FastBeanCopier.EMPTY_CLASS_ARRAY));
    }

    public static ValueObject of(Map<String, Object> mapVal) {
        return () -> mapVal;
    }

    default public <T> T as(Class<T> type) {
        return (T)FastBeanCopier.copy(this.values(), type, (String[])new String[0]);
    }
}

