/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.jetlinks.community.auth.service.AuthorizationSettingDetailService;
import org.jetlinks.community.auth.web.request.AuthorizationSettingDetail;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/autz-setting/detail"})
@Authorize
@Resource(id="autz-setting", name="\u6743\u9650\u5206\u914d", group={"system"})
@Tag(name="\u6743\u9650\u5206\u914d")
public class AuthorizationSettingDetailController {
    private final AuthorizationSettingDetailService settingService;

    @PostMapping(value={"/_save"})
    @SaveAction
    @Operation(summary="\u8d4b\u6743")
    public Mono<Boolean> saveSettings(@RequestBody Flux<AuthorizationSettingDetail> detailFlux) {
        return Authentication.currentReactive().flatMap(authentication -> this.settingService.saveDetail((Authentication)authentication, detailFlux).thenReturn((Object)true));
    }

    @GetMapping(value={"/{targetType}/{target}"})
    @SaveAction
    @Operation(summary="\u83b7\u53d6\u6743\u9650\u8be6\u60c5")
    public Mono<AuthorizationSettingDetail> getSettings(@PathVariable @Parameter(description="\u6743\u9650\u7c7b\u578b") String targetType, @PathVariable @Parameter(description="\u6743\u9650\u7c7b\u578b\u5bf9\u5e94\u6570\u636eID") String target) {
        return this.settingService.getSettingDetail(targetType, target);
    }

    public AuthorizationSettingDetailController(AuthorizationSettingDetailService settingService) {
        this.settingService = settingService;
    }
}

