/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.service;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.ReactiveAuthenticationManager;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.system.authorization.api.entity.UserEntity;
import org.hswebframework.web.system.authorization.api.event.UserDeletedEvent;
import org.hswebframework.web.system.authorization.api.service.reactive.ReactiveUserService;
import org.hswebframework.web.system.authorization.defaults.service.DefaultDimensionUserService;
import org.hswebframework.web.validator.ValidatorUtils;
import org.jetlinks.community.auth.entity.UserDetail;
import org.jetlinks.community.auth.entity.UserDetailEntity;
import org.jetlinks.community.auth.service.OrganizationService;
import org.jetlinks.community.auth.service.RoleService;
import org.jetlinks.community.auth.service.request.SaveUserDetailRequest;
import org.jetlinks.community.auth.service.request.SaveUserRequest;
import org.jetlinks.community.auth.utils.DimensionUserBindUtils;
import org.reactivestreams.Publisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

@Service
public class UserDetailService
extends GenericReactiveCrudService<UserDetailEntity, String> {
    private final ReactiveUserService userService;
    private final RoleService roleService;
    private final OrganizationService organizationService;
    private final ReactiveAuthenticationManager authenticationManager;
    private static final UserDetailEntity emptyDetail = new UserDetailEntity();
    private DefaultDimensionUserService dimensionUserService;

    public Mono<UserDetail> findUserDetail(String userId) {
        return Mono.zip((Mono)this.userService.findById(userId), (Mono)this.findById(userId).defaultIfEmpty((Object)emptyDetail), (Mono)this.authenticationManager.getByUserId(userId).map(a -> a.getDimensions()).defaultIfEmpty(Collections.emptyList())).map(tp4 -> UserDetail.of((UserEntity)tp4.getT1()).with((UserDetailEntity)((Object)((Object)tp4.getT2()))).withDimension((List)tp4.getT3()));
    }

    public Mono<Void> saveUserDetail(String userId, SaveUserDetailRequest request) {
        ValidatorUtils.tryValidate((Object)request, (Class[])new Class[0]);
        UserDetailEntity entity = (UserDetailEntity)((Object)FastBeanCopier.copy((Object)request, (Object)((Object)new UserDetailEntity()), (String[])new String[0]));
        entity.setId(userId);
        UserEntity userEntity = new UserEntity();
        userEntity.setId((Object)userId);
        userEntity.setName(request.getName());
        return ((Mono)this.save((Object)entity).then(this.userService.saveUser(Mono.just((Object)userEntity))).as(LocaleUtils::transform)).then();
    }

    public Mono<PagerResult<UserDetail>> queryUserDetail(QueryParamEntity query) {
        return Mono.zip((Mono)this.userService.countUser((QueryParam)query), (Mono)this.userService.findUser((QueryParam)query).collectList()).flatMap(tp2 -> {
            List userList = (List)tp2.getT2();
            return ((ReactiveQuery)this.createQuery().in(GenericEntity::getId, (Collection)userList.stream().map(UserEntity::getId).collect(Collectors.toList()))).fetch().collectMap(GenericEntity::getId).flatMap(userDetailMap -> {
                List userDetailList = userList.stream().map(user -> {
                    UserDetail userDetail = UserDetail.of(user);
                    UserDetailEntity entity = (UserDetailEntity)((Object)((Object)((Object)((Object)userDetailMap.get(user.getId())))));
                    if (entity != null) {
                        userDetail = userDetail.with(entity);
                    }
                    return userDetail;
                }).collect(Collectors.toList());
                return Mono.just((Object)PagerResult.of((int)((Integer)tp2.getT1()), userDetailList, (QueryParam)query));
            });
        });
    }

    @Transactional
    public Mono<String> saveUser(SaveUserRequest request) {
        request.validate();
        UserDetail detail = request.getUser();
        boolean isUpdate = StringUtils.hasText((String)detail.getId());
        UserEntity entity = request.getUser().toUserEntity();
        return (Mono)this.userService.saveUser(Mono.just((Object)entity)).then(Mono.fromSupplier(() -> ((UserEntity)entity).getId())).flatMap(userId -> {
            detail.setId((String)userId);
            return this.save((Object)detail.toDetailEntity()).then(this.roleService.bindUser(Collections.singleton(userId), request.getRoleIdList(), isUpdate)).then(this.organizationService.bindUser(Collections.singleton(userId), request.getOrgIdList(), isUpdate)).then(this.bindInstitution(Collections.singleton(userId), request.getInstitutionIdList(), isUpdate)).thenReturn(userId);
        }).as(LocaleUtils::transform);
    }

    @Transactional
    public Mono<Void> bindInstitution(Collection<String> userIdList, Collection<String> institutionIdList, boolean removeOldBind) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Mono.empty();
        }
        return DimensionUserBindUtils.bindUser(this.dimensionUserService, userIdList, "institution", institutionIdList, removeOldBind);
    }

    @EventListener
    public void handleUserDeletedEvent(UserDeletedEvent event) {
        event.async((Publisher)this.deleteById(event.getUser().getId()));
    }

    public UserDetailService(ReactiveUserService userService, RoleService roleService, OrganizationService organizationService, ReactiveAuthenticationManager authenticationManager, DefaultDimensionUserService dimensionUserService) {
        this.userService = userService;
        this.roleService = roleService;
        this.organizationService = organizationService;
        this.authenticationManager = authenticationManager;
        this.dimensionUserService = dimensionUserService;
    }
}

