/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.initialize;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.DefaultDimensionType;
import org.hswebframework.web.authorization.events.AuthorizationInitializeEvent;
import org.hswebframework.web.authorization.simple.SimpleAuthentication;
import org.hswebframework.web.authorization.simple.SimplePermission;
import org.hswebframework.web.system.authorization.api.entity.ActionEntity;
import org.hswebframework.web.system.authorization.api.entity.PermissionEntity;
import org.hswebframework.web.system.authorization.defaults.service.DefaultPermissionService;
import org.jetlinks.community.auth.entity.MenuEntity;
import org.jetlinks.community.auth.service.DefaultMenuService;
import org.jetlinks.community.auth.service.request.MenuGrantRequest;
import org.jetlinks.community.auth.web.request.AuthorizationSettingDetail;
import org.reactivestreams.Publisher;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class MenuAuthenticationInitializeService {
    private final DefaultMenuService menuService;
    private final DefaultPermissionService permissionService;

    @EventListener
    public void refactorPermission(AuthorizationInitializeEvent event) {
        if (event.getAuthentication().getDimensions().isEmpty()) {
            return;
        }
        event.async((Publisher)Mono.zip((Mono)((ReactiveQuery)this.permissionService.createQuery().where(PermissionEntity::getStatus, (Object)1)).fetch().collectMap(PermissionEntity::getId, Function.identity()), (Mono)((ReactiveQuery)this.menuService.createQuery().where(MenuEntity::getStatus, (Object)1)).fetch().collectList(), (Mono)this.menuService.getGrantedMenus(QueryParamEntity.of(), event.getAuthentication().getDimensions()).collectList().filter(CollectionUtils::isNotEmpty)).flatMapIterable(tp3 -> {
            Map permissions = (Map)tp3.getT1();
            List menus = (List)tp3.getT2();
            List grantedMenus = (List)tp3.getT3();
            MenuGrantRequest request = new MenuGrantRequest();
            request.setTargetType(DefaultDimensionType.role.getId());
            request.setTargetId("merge");
            request.setMenus(grantedMenus);
            AuthorizationSettingDetail detail = request.toAuthorizationSettingDetail(menus);
            return detail.getPermissionList().stream().map(per -> {
                HashSet<Object> actions;
                PermissionEntity entity = (PermissionEntity)permissions.get(per.getId());
                if (entity == null || per.getActions() == null) {
                    return null;
                }
                if (CollectionUtils.isEmpty((Collection)entity.getActions())) {
                    actions = new HashSet();
                } else {
                    Set defActions = entity.getActions().stream().map(ActionEntity::getAction).collect(Collectors.toSet());
                    actions = new HashSet<String>(per.getActions());
                    actions.retainAll(defActions);
                }
                return SimplePermission.builder().id(entity.getId()).name(entity.getName()).options(entity.getProperties()).actions(actions).build();
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }).collectList().filter(CollectionUtils::isNotEmpty).doOnNext(mapping -> {
            SimpleAuthentication authentication = new SimpleAuthentication();
            authentication.setUser(event.getAuthentication().getUser());
            authentication.setPermissions(mapping);
            event.setAuthentication(event.getAuthentication().merge((Authentication)authentication));
        }));
    }

    public MenuAuthenticationInitializeService(DefaultMenuService menuService, DefaultPermissionService permissionService) {
        this.menuService = menuService;
        this.permissionService = permissionService;
    }
}

