/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import org.hibernate.validator.constraints.Length;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.utils.DigestUtils;
import org.hswebframework.web.validator.CreateGroup;
import org.springframework.util.StringUtils;

@Table(name="s_user_settings", indexes={@Index(name="idx_user_id_type", columnList="user_id,type")})
@Comment(value="\u7528\u6237\u8bbe\u7f6e\u4fe1\u606f")
public class UserSettingEntity
extends GenericEntity<String> {
    @Schema(description="\u7528\u6237ID", hidden=true)
    @Column(length=64, nullable=false, updatable=false)
    @Length(max=64, groups={CreateGroup.class})
    private @Length(max=64, groups={CreateGroup.class}) String userId;
    @Schema(description="\u914d\u7f6e\u7c7b\u578b,\u5982: search")
    @Column(length=64, nullable=false, updatable=false)
    @Length(max=64, groups={CreateGroup.class})
    private @Length(max=64, groups={CreateGroup.class}) String type;
    @Schema(description="\u914d\u7f6ekey,\u5982: user-search")
    @Column(length=64, nullable=false, updatable=false)
    @Length(max=64, groups={CreateGroup.class})
    private @Length(max=64, groups={CreateGroup.class}) String key;
    @Schema(description="\u914d\u7f6e\u540d\u79f0")
    @Column(length=128)
    @Length(max=128)
    private @Length(max=128) String name;
    @Schema(description="\u914d\u7f6e\u8bf4\u660e")
    private String description;
    @Schema(description="\u914d\u7f6e\u5185\u5bb9")
    @Column
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    private String content;
    @Column(updatable=false, nullable=false)
    @DefaultValue(generator="current_time")
    @Schema(description="\u521b\u5efa\u65f6\u95f4", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;

    public String getId() {
        if (!StringUtils.hasText((String)((String)super.getId()))) {
            this.generateId();
        }
        return (String)super.getId();
    }

    public String generateId() {
        String id = UserSettingEntity.generateId(this.userId, this.type, this.key);
        this.setId(id);
        return id;
    }

    public static String generateId(String userId, String type, String key) {
        return DigestUtils.md5Hex((String)String.join((CharSequence)"|", userId, type, key));
    }

    public String getUserId() {
        return this.userId;
    }

    public String getType() {
        return this.type;
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getContent() {
        return this.content;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }
}

