/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.utils.DigestUtils;
import org.jetlinks.community.auth.entity.MenuView;
import org.springframework.util.ObjectUtils;

@Table(name="s_menu_bind", indexes={@Index(name="idx_menu_bind_dim_key", columnList="target_key")})
@Comment(value="\u83dc\u5355\u7ed1\u5b9a\u4fe1\u606f\u8868")
public class MenuBindEntity
extends GenericEntity<String> {
    @Schema(description="\u7ed1\u5b9a\u7ef4\u5ea6\u7c7b\u578b,\u6bd4\u5982role,user")
    @Column(nullable=false, length=32, updatable=false)
    @NotBlank
    private String targetType;
    @Schema(description="\u7ed1\u5b9a\u7ef4\u5ea6ID")
    @Column(nullable=false, length=64, updatable=false)
    @NotBlank
    private String targetId;
    @Schema(description="\u7ed1\u5b9akey", hidden=true)
    @Column(nullable=false, length=64, updatable=false)
    @NotBlank
    private String targetKey;
    @Schema(description="\u83dc\u5355ID")
    @Column(nullable=false, length=64, updatable=false)
    @NotBlank
    private String menuId;
    @Schema(description="\u5176\u4ed6\u914d\u7f6e")
    @Column
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    @JsonCodec
    private Map<String, Object> options;
    @Schema(description="\u5206\u914d\u7684\u6309\u94ae")
    @Column
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    @JsonCodec
    private List<MenuView.ButtonView> buttons;
    @Schema(description="\u51b2\u7a81\u65f6\u662f\u5426\u5408\u5e76")
    @Column
    @DefaultValue(value="true")
    private Boolean merge;
    @Schema(description="\u51b2\u7a81\u65f6\u5408\u5e76\u4f18\u5148\u7ea7")
    @Column
    @DefaultValue(value="10")
    private Integer priority;

    public String getId() {
        if (ObjectUtils.isEmpty((Object)super.getId())) {
            this.generateId();
        }
        return (String)super.getId();
    }

    public void generateId() {
        this.generateTargetKey();
        this.setId(DigestUtils.md5Hex((String)String.join((CharSequence)"|", this.targetKey, this.menuId)));
    }

    public void generateTargetKey() {
        this.setTargetKey(MenuBindEntity.generateTargetKey(this.targetType, this.targetId));
    }

    public static String generateTargetKey(String dimensionType, String dimensionId) {
        return DigestUtils.md5Hex((String)String.join((CharSequence)"|", dimensionType, dimensionId));
    }

    public MenuBindEntity withTarget(String targetType, String targetId) {
        this.targetId = targetId;
        this.targetType = targetType;
        this.generateTargetKey();
        return this;
    }

    public MenuBindEntity withMerge(Boolean merge, Integer priority) {
        this.merge = merge;
        this.priority = priority;
        return this;
    }

    public static MenuBindEntity of(MenuView view) {
        MenuBindEntity entity = new MenuBindEntity();
        entity.setMenuId((String)view.getId());
        entity.setOptions(view.getOptions());
        if (CollectionUtils.isNotEmpty(view.getButtons())) {
            entity.setButtons(view.getButtons().stream().filter(MenuView.ButtonView::isGranted).collect(Collectors.toList()));
        }
        return entity;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetKey() {
        return this.targetKey;
    }

    public String getMenuId() {
        return this.menuId;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public List<MenuView.ButtonView> getButtons() {
        return this.buttons;
    }

    public Boolean getMerge() {
        return this.merge;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public void setMenuId(String menuId) {
        this.menuId = menuId;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setButtons(List<MenuView.ButtonView> buttons) {
        this.buttons = buttons;
    }

    public void setMerge(Boolean merge) {
        this.merge = merge;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }
}

