/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.jetlinks.community.auth.entity.ThirdPartyUserBindEntity;
import org.jetlinks.community.auth.web.request.ThirdPartyBindUserInfo;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/user/third-party"})
@Resource(id="user-third-party-manager", name="\u7b2c\u4e09\u65b9\u7528\u6237")
@Tag(name="\u7b2c\u4e09\u65b9\u7528\u6237")
public class ThirdPartyUserController {
    private final ReactiveRepository<ThirdPartyUserBindEntity, String> repository;

    @PatchMapping(value={"/{type}/{provider}"})
    @Operation(summary="\u7ed1\u5b9a\u7528\u6237")
    @SaveAction
    @Deprecated
    public Mono<Void> bindUser(@PathVariable String type, @PathVariable String provider, @RequestBody(required=false) Flux<ThirdPartyBindUserInfo> requestFlux) {
        return this.bind(type, provider, requestFlux);
    }

    @PostMapping(value={"/{type}/{provider}/_bind"})
    @Operation(summary="\u7ed1\u5b9a\u7528\u6237")
    @SaveAction
    public Mono<Void> bind(@PathVariable String type, @PathVariable String provider, @RequestBody(required=false) Flux<ThirdPartyBindUserInfo> requestFlux) {
        return ((Mono)requestFlux.map(request -> {
            ThirdPartyUserBindEntity entity = new ThirdPartyUserBindEntity();
            entity.setType(type);
            entity.setProvider(provider);
            entity.setThirdPartyUserId(request.getThirdPartyUserId());
            entity.setUserId(request.getUserId());
            entity.setProviderName(request.getProviderName());
            entity.generateId();
            return entity;
        }).as(arg_0 -> this.repository.save(arg_0))).then();
    }

    @PostMapping(value={"/{id}/_unbind"})
    @Operation(summary="\u89e3\u7ed1\u7528\u6237")
    @SaveAction
    public Mono<Void> unbind(@PathVariable String id) {
        return this.repository.deleteById((Object)id).then();
    }

    @GetMapping(value={"/{type}/{provider}"})
    @Operation(summary="\u83b7\u53d6\u7ed1\u5b9a\u4fe1\u606f")
    @QueryAction
    public Flux<ThirdPartyBindUserInfo> queryBindings(@PathVariable String type, @PathVariable String provider) {
        return ((ReactiveQuery)((ReactiveQuery)this.repository.createQuery().where(ThirdPartyUserBindEntity::getType, (Object)type)).and(ThirdPartyUserBindEntity::getProvider, (Object)provider)).fetch().map(bind -> ThirdPartyBindUserInfo.of((String)bind.getId(), bind.getUserId(), bind.getProviderName(), bind.getThirdPartyUserId()));
    }

    @GetMapping(value={"/me"})
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u4fe1\u606f")
    @Authorize(merge=false)
    public Flux<ThirdPartyUserBindEntity> getCurrentUserBindings() {
        return Authentication.currentReactive().flatMapMany(auth -> ((ReactiveQuery)this.repository.createQuery().where(ThirdPartyUserBindEntity::getUserId, (Object)auth.getUser().getId())).fetch());
    }

    @DeleteMapping(value={"/me/{bindingId}"})
    @Operation(summary="\u89e3\u7ed1\u5f53\u524d\u7528\u6237\u7ed1\u5b9a\u4fe1\u606f")
    @Authorize(merge=false)
    public Mono<Void> deleteBinding(@PathVariable String bindingId) {
        return Authentication.currentReactive().flatMap(auth -> ((ReactiveDelete)((ReactiveDelete)this.repository.createDelete().where(ThirdPartyUserBindEntity::getUserId, (Object)auth.getUser().getId())).and(GenericEntity::getId, (Object)bindingId)).execute()).then();
    }

    public ThirdPartyUserController(ReactiveRepository<ThirdPartyUserBindEntity, String> repository) {
        this.repository = repository;
    }
}

