/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.community.auth.entity.PermissionInfo;

public class MenuButtonInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Schema(description="\u6309\u94aeID")
    private String id;
    @Schema(description="\u6309\u94ae\u540d\u79f0")
    private String name;
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Schema(description="\u6743\u9650\u4fe1\u606f")
    private List<PermissionInfo> permissions;
    @Schema(description="\u5176\u4ed6\u914d\u7f6e")
    private Map<String, Object> options;

    public boolean hasPermission(BiPredicate<String, Collection<String>> predicate) {
        if (CollectionUtils.isEmpty(this.permissions)) {
            return true;
        }
        for (PermissionInfo permission : this.permissions) {
            if (predicate.test(permission.getPermission(), permission.getActions())) continue;
            return false;
        }
        return true;
    }

    public static MenuButtonInfo of(String id, String name, String permission, String ... actions) {
        MenuButtonInfo info = new MenuButtonInfo();
        info.setId(id);
        info.setName(name);
        info.setPermissions(Arrays.asList(PermissionInfo.of(permission, new HashSet<String>(Arrays.asList(actions)))));
        return info;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PermissionInfo> getPermissions() {
        return this.permissions;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPermissions(List<PermissionInfo> permissions) {
        this.permissions = permissions;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }
}

