/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.configuration;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Map;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.authorization.token.redis.RedisUserTokenManager;
import org.jetlinks.community.auth.configuration.MenuProperties;
import org.jetlinks.community.auth.web.WebFluxUserController;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.core.ReactiveRedisOperations;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={MenuProperties.class})
public class CustomAuthenticationConfiguration {
    @Bean
    @Primary
    public WebFluxUserController webFluxUserController() {
        return new WebFluxUserController();
    }

    @Bean
    @ConfigurationProperties(prefix="hsweb.user-token")
    public UserTokenManager userTokenManager(ReactiveRedisOperations<Object, Object> template, ApplicationEventPublisher eventPublisher) {
        RedisUserTokenManager userTokenManager = new RedisUserTokenManager(template);
        userTokenManager.setLocalCache((Map)Caffeine.newBuilder().expireAfterAccess(Duration.ofMinutes(10L)).expireAfterWrite(Duration.ofHours(2L)).build().asMap());
        userTokenManager.setEventPublisher(eventPublisher);
        return userTokenManager;
    }
}

