/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.service;

import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.crud.service.GenericReactiveTreeSupportCrudService;
import org.hswebframework.web.id.IDGenerator;
import org.hswebframework.web.system.authorization.api.entity.DimensionUserEntity;
import org.hswebframework.web.system.authorization.defaults.service.DefaultDimensionUserService;
import org.jetlinks.community.auth.dimension.OrgDimensionType;
import org.jetlinks.community.auth.entity.OrganizationEntity;
import org.jetlinks.community.auth.utils.DimensionUserBindUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Service
public class OrganizationService
extends GenericReactiveTreeSupportCrudService<OrganizationEntity, String> {
    private DefaultDimensionUserService dimensionUserService;

    public IDGenerator<String> getIDGenerator() {
        return IDGenerator.UUID;
    }

    public void setChildren(OrganizationEntity entity, List<OrganizationEntity> children) {
        entity.setChildren(children);
    }

    @Transactional
    public Mono<Integer> bindUser(String orgId, List<String> userIdList) {
        Flux userIdStream = Flux.fromIterable(userIdList);
        return this.findById(orgId).flatMap(org -> (Mono)userIdStream.map(userId -> {
            DimensionUserEntity userEntity = new DimensionUserEntity();
            userEntity.setUserId(userId);
            userEntity.setUserName(userId);
            userEntity.setDimensionId(orgId);
            userEntity.setDimensionTypeId(OrgDimensionType.org.getId());
            userEntity.setDimensionName(org.getName());
            return userEntity;
        }).as(arg_0 -> ((DefaultDimensionUserService)this.dimensionUserService).save(arg_0))).map(SaveResult::getTotal);
    }

    @Transactional
    public Mono<Integer> unbindUser(String orgId, List<String> userIdList) {
        Flux userIdStream = Flux.fromIterable(userIdList);
        return userIdStream.collectList().filter(CollectionUtils::isNotEmpty).flatMap(newUserIdList -> ((ReactiveDelete)((ReactiveDelete)((ReactiveDelete)this.dimensionUserService.createDelete().where(DimensionUserEntity::getDimensionTypeId, (Object)OrgDimensionType.org.getId())).in(DimensionUserEntity::getUserId, (Collection)newUserIdList)).and(DimensionUserEntity::getDimensionId, (Object)orgId)).execute());
    }

    @Transactional
    public Mono<Void> bindUser(Collection<String> userIdList, Collection<String> orgIdList, boolean removeOldBind) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Mono.empty();
        }
        return DimensionUserBindUtils.bindUser(this.dimensionUserService, userIdList, OrgDimensionType.org.getId(), orgIdList, removeOldBind);
    }

    public OrganizationService(DefaultDimensionUserService dimensionUserService) {
        this.dimensionUserService = dimensionUserService;
    }
}

