/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.entity;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.DefaultDimensionType;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.system.authorization.api.entity.UserEntity;
import org.jetlinks.community.auth.dimension.OrgDimensionType;
import org.jetlinks.community.auth.entity.OrganizationInfo;
import org.jetlinks.community.auth.entity.RoleInfo;
import org.jetlinks.community.auth.entity.UserDetailEntity;
import org.jetlinks.reactor.ql.utils.CastUtils;

public class UserDetail {
    @Schema(description="\u7528\u6237ID")
    private String id;
    @Schema(description="\u7528\u6237\u540d")
    private String username;
    @Schema(hidden=true)
    private String password;
    @Schema(hidden=false)
    private String type;
    @Schema(description="\u7528\u6237\u72b6\u6001\u30021\u542f\u7528\uff0c0\u7981\u7528")
    private Byte status;
    @Schema(description="\u59d3\u540d")
    private String name;
    @Schema(description="email")
    private String email;
    @Schema(description="\u8054\u7cfb\u7535\u8bdd")
    private String telephone;
    @Schema(description="\u5934\u50cf\u56fe\u7247\u5730\u5740")
    private String avatar;
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    private long createTime;
    @Schema(description="\u89d2\u8272\u4fe1\u606f")
    private List<RoleInfo> roleList;
    @Schema(description="\u6240\u5728\u673a\u6784(\u90e8\u95e8)\u4fe1\u606f")
    private List<OrganizationInfo> orgList;
    @Schema(description="\u6240\u5728\u5355\u4f4d\u4fe1\u606f")
    private List<OrganizationInfo> institutionList;
    private boolean tenantDisabled;

    public static UserDetail of(UserEntity entity) {
        return new UserDetail().with(entity);
    }

    public UserDetail with(UserDetailEntity entity) {
        this.setAvatar(entity.getAvatar());
        this.setDescription(entity.getDescription());
        this.setTelephone(entity.getTelephone());
        this.setEmail(entity.getEmail());
        return this;
    }

    public UserDetail with(UserEntity entity) {
        this.setId(entity.getId());
        this.setName(entity.getName());
        if (entity.getCreateTime() != null) {
            this.setCreateTime(entity.getCreateTime());
        }
        this.setUsername(entity.getUsername());
        this.setStatus(entity.getStatus());
        this.setType("normal");
        return this;
    }

    public UserDetail with(Authentication authentication) {
        this.setId(authentication.getUser().getId());
        this.setCreateTime(System.currentTimeMillis());
        this.setName(authentication.getUser().getName());
        this.setUsername(authentication.getUser().getUsername());
        return this;
    }

    public UserDetail withDimension(List<Dimension> details) {
        this.roleList = details.stream().filter(dim -> DefaultDimensionType.role.isSameType(dim.getType())).map(RoleInfo::of).collect(Collectors.toList());
        this.orgList = details.stream().filter(dim -> OrgDimensionType.org.isSameType(dim.getType())).filter(dim -> dim.getOption("direct").map(CastUtils::castBoolean).orElse(false)).map(OrganizationInfo::of).collect(Collectors.toList());
        this.institutionList = details.stream().filter(dim -> "institution".equals(dim.getType().getId())).filter(dim -> dim.getOption("direct").map(CastUtils::castBoolean).orElse(false)).map(OrganizationInfo::of).collect(Collectors.toList());
        return this;
    }

    public UserEntity toUserEntity() {
        UserEntity userEntity = new UserEntity();
        userEntity.setId((Object)this.id);
        userEntity.setName(this.name);
        userEntity.setUsername(this.username);
        userEntity.setPassword(this.password);
        userEntity.setType(this.type);
        return userEntity;
    }

    public UserDetailEntity toDetailEntity() {
        return (UserDetailEntity)((Object)FastBeanCopier.copy((Object)this, (Object)((Object)new UserDetailEntity()), (String[])new String[0]));
    }

    @JsonIgnore
    public List<String> getOrgIdList() {
        return this.orgList == null ? null : this.orgList.stream().map(OrganizationInfo::getId).collect(Collectors.toList());
    }

    @JsonIgnore
    public List<String> getRoleIdList() {
        return this.roleList == null ? null : this.roleList.stream().map(RoleInfo::getId).collect(Collectors.toList());
    }

    public String getId() {
        return this.id;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getType() {
        return this.type;
    }

    public Byte getStatus() {
        return this.status;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public String getTelephone() {
        return this.telephone;
    }

    public String getAvatar() {
        return this.avatar;
    }

    public String getDescription() {
        return this.description;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public List<RoleInfo> getRoleList() {
        return this.roleList;
    }

    public List<OrganizationInfo> getOrgList() {
        return this.orgList;
    }

    public List<OrganizationInfo> getInstitutionList() {
        return this.institutionList;
    }

    public boolean isTenantDisabled() {
        return this.tenantDisabled;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setStatus(Byte status) {
        this.status = status;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setTelephone(String telephone) {
        this.telephone = telephone;
    }

    public void setAvatar(String avatar) {
        this.avatar = avatar;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public void setRoleList(List<RoleInfo> roleList) {
        this.roleList = roleList;
    }

    public void setOrgList(List<OrganizationInfo> orgList) {
        this.orgList = orgList;
    }

    public void setInstitutionList(List<OrganizationInfo> institutionList) {
        this.institutionList = institutionList;
    }

    public void setTenantDisabled(boolean tenantDisabled) {
        this.tenantDisabled = tenantDisabled;
    }
}

