/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.web.request;

import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.hswebframework.web.authorization.Dimension;
import org.hswebframework.web.system.authorization.api.entity.AuthorizationSettingEntity;
import org.hswebframework.web.system.authorization.api.entity.DataAccessEntity;

public class AuthorizationSettingDetail {
    @NotBlank
    @Schema(description="\u6743\u9650\u7c7b\u578b,\u5982: org,openApi")
    private String targetType;
    @NotBlank
    @Schema(description="\u6743\u9650\u7c7b\u578b\u5bf9\u5e94\u7684\u6570\u636eID")
    private String targetId;
    @Schema(description="\u51b2\u7a81\u65f6\u662f\u5426\u5408\u5e76")
    private boolean merge = true;
    @Schema(description="\u51b2\u7a81\u65f6\u5408\u5e76\u4f18\u5148\u7ea7")
    private int priority = 10;
    @Schema(description="\u6743\u9650\u5217\u8868")
    private List<PermissionInfo> permissionList;

    public boolean hasPermission(String id, Collection<String> actions) {
        if (CollectionUtils.isEmpty(this.permissionList)) {
            return false;
        }
        for (PermissionInfo info : this.permissionList) {
            if (!Objects.equals(info.getId(), id)) continue;
            if (CollectionUtils.isEmpty(actions)) {
                return true;
            }
            if (!CollectionUtils.isNotEmpty(info.getActions()) || !info.getActions().containsAll(actions)) continue;
            return true;
        }
        return false;
    }

    public static AuthorizationSettingDetail fromEntity(List<AuthorizationSettingEntity> entities) {
        AuthorizationSettingDetail detail = new AuthorizationSettingDetail();
        detail.setPermissionList(new ArrayList<PermissionInfo>());
        for (AuthorizationSettingEntity entity : entities) {
            detail.setTargetId(entity.getDimensionTarget());
            detail.setTargetType(entity.getDimensionType());
            detail.getPermissionList().add(new PermissionInfo().unwrap(entity));
        }
        return detail;
    }

    public List<AuthorizationSettingEntity> toEntity() {
        return this.toEntity(null);
    }

    public List<AuthorizationSettingEntity> toEntity(Dimension dimension) {
        if (CollectionUtils.isEmpty(this.permissionList)) {
            return Collections.emptyList();
        }
        return this.permissionList.stream().filter(permissionInfo -> CollectionUtils.isNotEmpty((Collection)((PermissionInfo)permissionInfo).actions)).map(permissionInfo -> {
            AuthorizationSettingEntity entity = new AuthorizationSettingEntity();
            entity.setDimensionTarget(this.targetId);
            entity.setDimensionType(this.targetType);
            if (null != dimension) {
                entity.setDimensionTypeName(dimension.getType().getName());
                entity.setDimensionTargetName(dimension.getName());
            }
            entity.setState(Byte.valueOf((byte)1));
            entity.setMerge(Boolean.valueOf(this.merge));
            entity.setPriority(Integer.valueOf(this.priority));
            ((PermissionInfo)permissionInfo).wrap(entity);
            return entity;
        }).collect(Collectors.toList());
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public int getPriority() {
        return this.priority;
    }

    public List<PermissionInfo> getPermissionList() {
        return this.permissionList;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setPermissionList(List<PermissionInfo> permissionList) {
        this.permissionList = permissionList;
    }

    public static class FieldAccess {
        private String name;
        private Set<String> action;

        public String getName() {
            return this.name;
        }

        public Set<String> getAction() {
            return this.action;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAction(Set<String> action) {
            this.action = action;
        }

        public FieldAccess(String name, Set<String> action) {
            this.name = name;
            this.action = action;
        }

        public FieldAccess() {
        }
    }

    public static class DataAccess {
        private String type;
        private Set<String> actions;
        private Map<String, Object> config;

        public static DataAccess of(DataAccessEntity entity) {
            DataAccess access = new DataAccess();
            access.config = entity.getConfig();
            access.actions = new HashSet<String>();
            access.type = (String)access.getConfig().get("scopeType");
            return access;
        }

        public List<DataAccessEntity> toEntity() {
            if (CollectionUtils.isEmpty(this.actions)) {
                return Collections.emptyList();
            }
            return this.actions.stream().map(action -> {
                DataAccessEntity entity = new DataAccessEntity();
                entity.setType("DIMENSION_SCOPE");
                HashMap<String, Object> config = new HashMap<String, Object>();
                if (null != this.config) {
                    config.putAll(this.config);
                }
                config.put("scopeType", this.type);
                config.put("children", true);
                entity.setConfig(config);
                entity.setAction(action);
                return entity;
            }).collect(Collectors.toList());
        }

        public String getType() {
            return this.type;
        }

        public Set<String> getActions() {
            return this.actions;
        }

        public Map<String, Object> getConfig() {
            return this.config;
        }

        public void setType(String type) {
            this.type = type;
        }

        public void setActions(Set<String> actions) {
            this.actions = actions;
        }

        public void setConfig(Map<String, Object> config) {
            this.config = config;
        }
    }

    @Generated
    public static class PermissionInfo {
        @NotBlank
        @Schema(description="\u6743\u9650ID")
        private String id;
        @Schema(description="\u5141\u8bb8\u6267\u884c\u7684\u64cd\u4f5c")
        private Set<String> actions;
        @Hidden
        private List<FieldAccess> fieldAccess;
        @Hidden
        private List<DataAccess> dataAccess;

        private PermissionInfo unwrap(AuthorizationSettingEntity entity) {
            this.id = entity.getPermission();
            this.actions = entity.getActions();
            this.fieldAccess = new ArrayList<FieldAccess>();
            this.dataAccess = new ArrayList<DataAccess>();
            LinkedHashMap<String, FieldAccess> filedAccessMap = new LinkedHashMap<String, FieldAccess>();
            LinkedHashMap<String, DataAccess> dataAccessMap = new LinkedHashMap<String, DataAccess>();
            if (CollectionUtils.isNotEmpty((Collection)entity.getDataAccesses())) {
                for (DataAccessEntity access : entity.getDataAccesses()) {
                    if ("DENY_FIELDS".equalsIgnoreCase(access.getType())) {
                        Set fields = Optional.ofNullable(access.getConfig()).map(conf -> new HashSet((Collection)conf.get("fields"))).orElseGet(HashSet::new);
                        for (String field : fields) {
                            filedAccessMap.computeIfAbsent(field, filedName -> new FieldAccess((String)filedName, (Set<String>)new HashSet<String>())).getAction().add(access.getAction());
                        }
                        continue;
                    }
                    if (!"DIMENSION_SCOPE".equalsIgnoreCase(access.getType())) continue;
                    DataAccess dataAccess = DataAccess.of(access);
                    dataAccessMap.computeIfAbsent(dataAccess.getType(), __ -> dataAccess).actions.add(access.getAction());
                }
            }
            this.dataAccess.addAll(dataAccessMap.values());
            this.fieldAccess.addAll(filedAccessMap.values());
            return this;
        }

        private void wrap(AuthorizationSettingEntity entity) {
            entity.setPermission(this.id);
            entity.setActions(this.actions);
            ArrayList<DataAccessEntity> entities = new ArrayList<DataAccessEntity>();
            if (CollectionUtils.isNotEmpty(this.fieldAccess)) {
                HashMap<String, Set> group = new HashMap<String, Set>();
                for (FieldAccess fieldAccess : this.fieldAccess) {
                    for (String action : fieldAccess.getAction()) {
                        group.computeIfAbsent(action, r -> new HashSet()).add(fieldAccess.name);
                    }
                }
                for (Map.Entry entry : group.entrySet()) {
                    DataAccessEntity dataAccessEntity = new DataAccessEntity();
                    dataAccessEntity.setAction((String)entry.getKey());
                    dataAccessEntity.setType("DENY_FIELDS");
                    dataAccessEntity.setConfig(Collections.singletonMap("fields", entry.getValue()));
                    entities.add(dataAccessEntity);
                }
            }
            if (CollectionUtils.isNotEmpty(this.dataAccess)) {
                for (DataAccess access : this.dataAccess) {
                    entities.addAll(access.toEntity());
                }
            }
            entity.setDataAccesses(entities);
        }

        public static PermissionInfo of(String id, Collection<String> actions) {
            PermissionInfo info = new PermissionInfo();
            info.setId(id);
            info.setActions(new HashSet<String>(actions));
            return info;
        }

        public String getId() {
            return this.id;
        }

        public Set<String> getActions() {
            return this.actions;
        }

        public List<FieldAccess> getFieldAccess() {
            return this.fieldAccess;
        }

        public List<DataAccess> getDataAccess() {
            return this.dataAccess;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setActions(Set<String> actions) {
            this.actions = actions;
        }

        public void setFieldAccess(List<FieldAccess> fieldAccess) {
            this.fieldAccess = fieldAccess;
        }

        public void setDataAccess(List<DataAccess> dataAccess) {
            this.dataAccess = dataAccess;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PermissionInfo)) {
                return false;
            }
            PermissionInfo other = (PermissionInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PermissionInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }
    }
}

