/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.User;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.system.authorization.api.PasswordValidator;
import org.hswebframework.web.system.authorization.api.UsernameValidator;
import org.hswebframework.web.system.authorization.api.entity.UserEntity;
import org.hswebframework.web.system.authorization.defaults.service.DefaultReactiveUserService;
import org.jetlinks.community.web.response.ValidationResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import reactor.core.publisher.Mono;

public class WebFluxUserController
extends org.hswebframework.web.system.authorization.defaults.webflux.WebFluxUserController {
    @Autowired
    private DefaultReactiveUserService reactiveUserService;
    @Autowired(required=false)
    private PasswordValidator passwordValidator = password -> {};
    @Autowired(required=false)
    private UsernameValidator usernameValidator = username -> {
        if (StringUtils.isEmpty((CharSequence)username)) {
            throw new ValidationException("error.user_cannot_be_empty");
        }
    };

    @PostMapping(value={"/{id}/password/_reset"})
    @SaveAction
    @Operation(summary="\u91cd\u7f6e\u5bc6\u7801")
    public Mono<Boolean> resetPassword(@PathVariable String id, @RequestBody String password) {
        return Mono.defer(() -> {
            this.passwordValidator.validate(password);
            UserEntity user = new UserEntity();
            user.setPassword(password);
            user.setId((Object)id);
            return this.reactiveUserService.saveUser(Mono.just((Object)user));
        });
    }

    @PostMapping(value={"/username/_validate"})
    @Authorize(merge=false)
    @Operation(summary="\u7528\u6237\u540d\u9a8c\u8bc1")
    public Mono<ValidationResult> usernameValidate(@RequestBody(required=false) String username) {
        return LocaleUtils.currentReactive().flatMap(locale -> {
            this.usernameValidator.validate(username);
            return this.reactiveUserService.findByUsername(username).map(i -> ValidationResult.error((String)LocaleUtils.resolveMessage((String)"error.user_already_exist", (Locale)locale, (String)("\u7528\u6237" + username + "\u5df2\u5b58\u5728"), (Object[])new Object[]{username})));
        }).defaultIfEmpty((Object)ValidationResult.success()).onErrorResume(ValidationException.class, e -> e.getLocalizedMessageReactive().map(ValidationResult::error));
    }

    @PostMapping(value={"/password/_validate"})
    @Authorize(merge=false)
    @Operation(summary="\u5bc6\u7801\u9a8c\u8bc1")
    public Mono<ValidationResult> passwordValidate(@RequestBody(required=false) String password) {
        return Mono.fromSupplier(() -> {
            this.passwordValidator.validate(password);
            return ValidationResult.success();
        }).onErrorResume(ValidationException.class, e -> e.getLocalizedMessageReactive().map(ValidationResult::error));
    }

    @PostMapping(value={"/me/password/_validate"})
    @SaveAction
    @Operation(summary="\u6821\u9a8c\u5f53\u524d\u7528\u6237\u7684\u5bc6\u7801")
    @Authorize(merge=false)
    public Mono<ValidationResult> loginUserPasswordValidate(@RequestBody(required=false) String password) {
        return LocaleUtils.currentReactive().flatMap(locale -> Authentication.currentReactive().map(Authentication::getUser).map(User::getUsername).flatMap(username -> this.reactiveUserService.findByUsernameAndPassword(username, password).flatMap(ignore -> Mono.just((Object)ValidationResult.success()))).switchIfEmpty(Mono.just((Object)ValidationResult.error((String)LocaleUtils.resolveMessage((String)"error.password_not_correct", (Locale)locale, (String)"\u5bc6\u7801\u9519\u8bef", (Object[])new Object[0]))))).onErrorResume(ValidationException.class, e -> e.getLocalizedMessageReactive().map(ValidationResult::error));
    }

    public Mono<Boolean> saveUser(@RequestBody Mono<UserEntity> userMono) {
        return userMono.flatMap(user -> {
            boolean isNew = StringUtils.isEmpty((CharSequence)user.getId());
            Mono<Void> before = !isNew ? this.assertUserPermission(user.getId()) : Mono.empty();
            return before.then(super.saveUser(Mono.just((Object)user))).thenReturn((Object)true);
        });
    }

    public Mono<Boolean> deleteUser(@PathVariable String id) {
        return this.assertUserPermission(id).then(super.deleteUser(id));
    }

    public Mono<Integer> changeState(@PathVariable @Parameter(description="\u7528\u6237ID") String id, @PathVariable @Parameter(description="\u72b6\u6001,0\u7981\u7528,1\u542f\u7528") Byte state) {
        return this.assertUserPermission(id).then(super.changeState(id, state));
    }

    public Mono<UserEntity> getById(@PathVariable String id) {
        return this.assertUserPermission(id).then(super.getById((Object)id));
    }

    private Mono<Void> assertUserPermission(String userId) {
        return Mono.empty();
    }
}

