/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.timeseries.query;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.Interval;
import org.jetlinks.community.timeseries.query.Aggregation;
import org.jetlinks.community.timeseries.query.AggregationColumn;
import org.jetlinks.community.timeseries.query.Group;
import org.jetlinks.community.timeseries.query.TimeGroup;

public class AggregationQueryParam {
    private List<AggregationColumn> aggColumns = new ArrayList<AggregationColumn>();
    @Deprecated
    private TimeGroup groupByTime;
    private List<Group> groupBy = new ArrayList<Group>();
    private int limit;
    private long startWithTime = 0L;
    private long endWithTime = System.currentTimeMillis();
    private String timeProperty = "timestamp";
    private QueryParamEntity queryParam = new QueryParamEntity();

    public static AggregationQueryParam of() {
        return new AggregationQueryParam();
    }

    public <T> T as(Function<AggregationQueryParam, T> mapper) {
        return mapper.apply(this);
    }

    public AggregationQueryParam from(long time) {
        this.startWithTime = time;
        return this;
    }

    public AggregationQueryParam from(Date time) {
        if (null != time) {
            return this.from(time.getTime());
        }
        return this;
    }

    public AggregationQueryParam to(long time) {
        this.endWithTime = time;
        return this;
    }

    public AggregationQueryParam to(Date time) {
        if (null != time) {
            return this.to(time.getTime());
        }
        return this;
    }

    public AggregationQueryParam agg(AggregationColumn agg) {
        this.aggColumns.add(agg);
        return this;
    }

    public AggregationQueryParam agg(String property, String alias, Aggregation agg) {
        return this.agg(new AggregationColumn(property, alias, agg));
    }

    public AggregationQueryParam agg(String property, Aggregation agg) {
        return this.agg(property, property, agg);
    }

    public AggregationQueryParam sum(String property, String alias) {
        return this.agg(property, alias, Aggregation.SUM);
    }

    public AggregationQueryParam sum(String property) {
        return this.agg(property, Aggregation.SUM);
    }

    public AggregationQueryParam avg(String property, String alias) {
        return this.agg(property, alias, Aggregation.AVG);
    }

    public AggregationQueryParam avg(String property) {
        return this.agg(property, Aggregation.AVG);
    }

    public AggregationQueryParam count(String property, String alias) {
        return this.agg(property, alias, Aggregation.COUNT);
    }

    public AggregationQueryParam count(String property) {
        return this.agg(property, Aggregation.COUNT);
    }

    public AggregationQueryParam max(String property, String alias) {
        return this.agg(property, alias, Aggregation.MAX);
    }

    public AggregationQueryParam max(String property) {
        return this.agg(property, Aggregation.MAX);
    }

    public AggregationQueryParam min(String property, String alias) {
        return this.agg(property, alias, Aggregation.MIN);
    }

    public AggregationQueryParam min(String property) {
        return this.agg(property, Aggregation.MIN);
    }

    public AggregationQueryParam groupBy(Interval time, String alias, String format) {
        return this.groupBy(new TimeGroup(time, alias, format));
    }

    public AggregationQueryParam groupBy(Interval time, String format) {
        return this.groupBy(time, "time", format);
    }

    public AggregationQueryParam groupBy(TimeGroup timeGroup) {
        this.groupByTime = timeGroup;
        return this;
    }

    public AggregationQueryParam groupBy(Group group) {
        this.groupBy.add(group);
        return this;
    }

    public AggregationQueryParam groupBy(String property, String alias) {
        return this.groupBy(new Group(property, alias));
    }

    public AggregationQueryParam groupBy(String property) {
        return this.groupBy(new Group(property, property));
    }

    public <T> T execute(Function<AggregationQueryParam, T> executor) {
        return executor.apply(this);
    }

    public AggregationQueryParam filter(Consumer<Query<?, QueryParam>> consumer) {
        consumer.accept(Query.of((QueryParam)this.queryParam));
        return this;
    }

    public AggregationQueryParam filter(QueryParamEntity queryParam) {
        this.queryParam = queryParam;
        return this;
    }

    public AggregationQueryParam limit(int limit) {
        this.limit = limit;
        return this;
    }

    public List<AggregationColumn> getAggColumns() {
        return this.aggColumns;
    }

    @Deprecated
    public TimeGroup getGroupByTime() {
        return this.groupByTime;
    }

    public List<Group> getGroupBy() {
        return this.groupBy;
    }

    public int getLimit() {
        return this.limit;
    }

    public long getStartWithTime() {
        return this.startWithTime;
    }

    public long getEndWithTime() {
        return this.endWithTime;
    }

    public String getTimeProperty() {
        return this.timeProperty;
    }

    public QueryParamEntity getQueryParam() {
        return this.queryParam;
    }

    public void setAggColumns(List<AggregationColumn> aggColumns) {
        this.aggColumns = aggColumns;
    }

    @Deprecated
    public void setGroupByTime(TimeGroup groupByTime) {
        this.groupByTime = groupByTime;
    }

    public void setGroupBy(List<Group> groupBy) {
        this.groupBy = groupBy;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setStartWithTime(long startWithTime) {
        this.startWithTime = startWithTime;
    }

    public void setEndWithTime(long endWithTime) {
        this.endWithTime = endWithTime;
    }

    public void setTimeProperty(String timeProperty) {
        this.timeProperty = timeProperty;
    }

    public void setQueryParam(QueryParamEntity queryParam) {
        this.queryParam = queryParam;
    }
}

