/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.timeseries;

import java.util.Date;
import java.util.Map;
import java.util.Optional;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.timeseries.SimpleTimeSeriesData;

public interface TimeSeriesData
extends ValueObject {
    public static TimeSeriesData of(Date date, Map<String, Object> data) {
        return TimeSeriesData.of(date == null ? System.currentTimeMillis() : date.getTime(), data);
    }

    public static TimeSeriesData of(long timestamp, Map<String, Object> data) {
        return new SimpleTimeSeriesData(timestamp, data);
    }

    public long getTimestamp();

    public Map<String, Object> getData();

    default public Map<String, Object> values() {
        return this.getData();
    }

    default public Optional<Object> get(String name) {
        return Optional.ofNullable(this.getData().get(name));
    }

    default public <T> T as(Class<T> type) {
        return (T)FastBeanCopier.copy(this.getData(), type, (String[])new String[0]);
    }
}

