/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import javax.persistence.Column;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.utils.DigestUtils;
import org.jetlinks.community.rule.engine.enums.AlarmRecordState;

@Table(name="alarm_record")
@Comment(value="\u544a\u8b66\u8bb0\u5f55")
public class AlarmRecordEntity
extends GenericEntity<String> {
    @Column(length=64, nullable=false, updatable=false)
    @Schema(description="\u544a\u8b66\u914d\u7f6eID")
    private String alarmConfigId;
    @Column(length=64, nullable=false)
    @Schema(description="\u544a\u8b66\u914d\u7f6e\u540d\u79f0")
    private String alarmName;
    @Column(length=32, updatable=false)
    @Schema(description="\u544a\u8b66\u76ee\u6807\u7c7b\u578b")
    private String targetType;
    @Column(length=64, updatable=false)
    @Schema(description="\u544a\u8b66\u76ee\u6807Id")
    private String targetId;
    @Column(length=64, updatable=false)
    @Schema(description="\u544a\u8b66\u76ee\u6807Key")
    private String targetKey;
    @Column
    @Schema(description="\u544a\u8b66\u76ee\u6807\u540d\u79f0")
    private String targetName;
    @Column(length=32)
    @Schema(description="\u544a\u8b66\u6e90\u7c7b\u578b")
    private String sourceType;
    @Column(length=64)
    @Schema(description="\u544a\u8b66\u6e90Id")
    private String sourceId;
    @Column
    @Schema(description="\u544a\u8b66\u6e90\u540d\u79f0")
    private String sourceName;
    @Column
    @Schema(description="\u6700\u8fd1\u4e00\u6b21\u544a\u8b66\u65f6\u95f4")
    private Long alarmTime;
    @Column
    @Schema(description="\u5904\u7406\u65f6\u95f4")
    private Long handleTime;
    @Column
    @Schema(description="\u544a\u8b66\u7ea7\u522b")
    private Integer level;
    @Column(length=32)
    @Schema(description="\u544a\u8b66\u8bb0\u5f55\u72b6\u6001")
    @EnumCodec
    @ColumnType(javaType=String.class)
    @DefaultValue(value="normal")
    private AlarmRecordState state;
    @Column
    @Schema(description="\u8bf4\u660e")
    private String description;

    public String getTargetKey() {
        if (this.targetKey == null) {
            this.generateTargetKey();
        }
        return this.targetKey;
    }

    public void generateTargetKey() {
        this.setTargetKey(AlarmRecordEntity.generateId(this.targetId, this.targetType));
    }

    public void generateId() {
        this.setId(AlarmRecordEntity.generateId(this.targetId, this.targetType, this.alarmConfigId));
    }

    public static String generateId(String ... args) {
        return DigestUtils.md5Hex((String)String.join((CharSequence)"-", args));
    }

    public String getAlarmConfigId() {
        return this.alarmConfigId;
    }

    public String getAlarmName() {
        return this.alarmName;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getSourceType() {
        return this.sourceType;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public Long getAlarmTime() {
        return this.alarmTime;
    }

    public Long getHandleTime() {
        return this.handleTime;
    }

    public Integer getLevel() {
        return this.level;
    }

    public AlarmRecordState getState() {
        return this.state;
    }

    public String getDescription() {
        return this.description;
    }

    public void setAlarmConfigId(String alarmConfigId) {
        this.alarmConfigId = alarmConfigId;
    }

    public void setAlarmName(String alarmName) {
        this.alarmName = alarmName;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setTargetKey(String targetKey) {
        this.targetKey = targetKey;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public void setSourceId(String sourceId) {
        this.sourceId = sourceId;
    }

    public void setSourceName(String sourceName) {
        this.sourceName = sourceName;
    }

    public void setAlarmTime(Long alarmTime) {
        this.alarmTime = alarmTime;
    }

    public void setHandleTime(Long handleTime) {
        this.handleTime = handleTime;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setState(AlarmRecordState state) {
        this.state = state;
    }

    public void setDescription(String description) {
        this.description = description;
    }
}

