/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.validation.constraints.NotBlank;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.rule.engine.entity.AlarmConfigEntity;
import org.jetlinks.community.rule.engine.entity.SceneEntity;
import org.jetlinks.community.rule.engine.enums.AlarmState;
import org.jetlinks.community.rule.engine.enums.RuleInstanceState;
import org.jetlinks.community.rule.engine.scene.TriggerType;

public class AlarmConfigDetail {
    @Schema(description="\u544a\u8b66\u914d\u7f6eID")
    private String id;
    @Schema(description="\u540d\u79f0")
    private String name;
    @Schema(description="\u544a\u8b66\u76ee\u6807\u7c7b\u578b")
    private String targetType;
    @Schema(description="\u544a\u8b66\u7ea7\u522b")
    private Integer level;
    @Schema(description="\u5173\u8054\u573a\u666f")
    private List<SceneInfo> scene;
    @Schema(description="\u72b6\u6001")
    private AlarmState state;
    @Schema(description="\u573a\u666f\u89e6\u53d1\u7c7b\u578b")
    private TriggerType sceneTriggerType;
    @Schema(description="\u8bf4\u660e")
    private String description;
    @Schema(description="\u521b\u5efa\u8005ID(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private String creatorId;
    @Schema(description="\u521b\u5efa\u65f6\u95f4(\u53ea\u8bfb)", accessMode=Schema.AccessMode.READ_ONLY)
    private Long createTime;
    @Schema(description="\u66f4\u65b0\u8005ID", accessMode=Schema.AccessMode.READ_ONLY)
    private String modifierId;
    @Schema(description="\u66f4\u65b0\u65f6\u95f4")
    private Long modifyTime;

    public static AlarmConfigDetail of(AlarmConfigEntity entity) {
        return (AlarmConfigDetail)FastBeanCopier.copy((Object)((Object)entity), (Object)new AlarmConfigDetail(), (String[])new String[]{"sceneTriggerType"});
    }

    public AlarmConfigDetail withScene(List<SceneEntity> sceneEntityList) {
        ArrayList<SceneInfo> sceneList = new ArrayList<SceneInfo>();
        for (SceneEntity sceneEntity : sceneEntityList) {
            sceneList.add(SceneInfo.of(sceneEntity));
            TriggerType triggerType = sceneEntity.getTriggerType();
            if (this.sceneTriggerType != null && triggerType != TriggerType.manual) continue;
            this.sceneTriggerType = triggerType;
        }
        this.scene = sceneList;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public Integer getLevel() {
        return this.level;
    }

    public List<SceneInfo> getScene() {
        return this.scene;
    }

    public AlarmState getState() {
        return this.state;
    }

    public TriggerType getSceneTriggerType() {
        return this.sceneTriggerType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getModifierId() {
        return this.modifierId;
    }

    public Long getModifyTime() {
        return this.modifyTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public void setScene(List<SceneInfo> scene) {
        this.scene = scene;
    }

    public void setState(AlarmState state) {
        this.state = state;
    }

    public void setSceneTriggerType(TriggerType sceneTriggerType) {
        this.sceneTriggerType = sceneTriggerType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setModifierId(String modifierId) {
        this.modifierId = modifierId;
    }

    public void setModifyTime(Long modifyTime) {
        this.modifyTime = modifyTime;
    }

    public static class SceneInfo {
        @Schema(description="\u573a\u666f\u8054\u52a8ID")
        private String id;
        @Column(nullable=false)
        @Schema(description="\u573a\u666f\u8054\u52a8\u540d\u79f0")
        @NotBlank
        private String name;
        @Schema(description="\u89e6\u53d1\u5668\u7c7b\u578b")
        private TriggerType triggerType;
        @Schema(description="\u72b6\u6001")
        private RuleInstanceState state;

        public static SceneInfo of(SceneEntity entity) {
            return (SceneInfo)FastBeanCopier.copy((Object)((Object)entity), (Object)new SceneInfo(), (String[])new String[0]);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public TriggerType getTriggerType() {
            return this.triggerType;
        }

        public RuleInstanceState getState() {
            return this.state;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setTriggerType(TriggerType triggerType) {
            this.triggerType = triggerType;
        }

        public void setState(RuleInstanceState state) {
            this.state = state;
        }
    }
}

