package net.zstong.awump.inspection.web;

import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.extern.slf4j.Slf4j;
import net.zstong.awump.base.service.AwRegionService;
import net.zstong.awump.inspection.entity.AwInspectionPlanDevEntity;
import net.zstong.awump.inspection.entity.AwInspectionPlanEntity;
import net.zstong.awump.inspection.service.AwInspectionPlanDevService;
import net.zstong.awump.inspection.service.AwInspectionPlanService;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;


@RestController
@RequestMapping({"/aw/inspection/plan/dev"})
@Resource(id = "aw-inspection-plan-dev", name = "巡检计划设备明细接口")
@Tag(name = "巡检计划设备明细接口")
@Slf4j
public class AwInspectionPlanDevController implements ReactiveServiceCrudController<AwInspectionPlanDevEntity, String> {

    @Autowired
    private AwInspectionPlanDevService awInspectionPlanDevService;


    @Override
    public ReactiveCrudService<AwInspectionPlanDevEntity, String> getService() {
        return awInspectionPlanDevService;
    }


}
