package net.zstong.awump.base.entity;


import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.api.crud.entity.RecordModifierEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.crud.generator.Generators;
import org.hswebframework.web.validator.CreateGroup;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.sql.Timestamp;

/**
 * @author yuanhc
 * @date 2023-05-25
 */
@Getter
@Setter
public class BaseEntity<PK> extends GenericEntity<PK> implements RecordCreationEntity, RecordModifierEntity {


//    @Override
//    @GeneratedValue(generator = Generators.SNOW_FLAKE)
//    @Pattern(
//        regexp = "^[0-9a-zA-Z_\\-]+$",
//        message = "ID只能由数字,字母,下划线和中划线组成",
//        groups = CreateGroup.class)
//    @Schema(description = "ID")
//    public PK getId() {
//        return super.getId();
//    }

    /**
     * 备注
     */
    @Schema(description = "备注")
    @Column(name = "memo_", length = 200)
    private String memo;

    /**
     * 排序
     */
    @Schema(description = "排序")
    @Column(name = "sn_")
    private Integer sn;

    /**
     * 禁用标识【字典】（0：禁用，1：启用）
     */
    @Schema(description = "禁用标识【字典】（0：禁用，1：启用）")
    @Column(name = "flag_")
    private Integer flag;

    /**
     * 是否已删，1已删除，0未删除
     */
    @Schema(description = "是否已删，1已删除，0未删除")
    @Column(name = "is_dele_", length = 1)
    private String isDele;

    /**
     * 创建人
     */
    @Schema(description = "创建人")
    @Column(name = "creator_id_", length = 64)
    private String creatorId;

    /**
     * 创建人组织
     */
    @Schema(description = "创建人组织")
    @Column(name = "creator_org_id_", length = 64)
    private String creatorOrgId;

    /**
     * 创建时间
     */
    @Schema(description = "创建时间")
    @Column(name = "create_time_")
    @DefaultValue(generator = Generators.CURRENT_TIME)
    private Long createTime;

    /**
     * 更新人
     */
    @Schema(description = "更新人")
    @Column(name = "modifier_id_", length = 64)
    private String modifierId;

    /**
     * 更新时间
     */
    @Schema(description = "更新时间")
    @Column(name = "modify_time_")
    private Long modifyTime;

    /**
     * 版本号
     */
    @Schema(description = "版本号")
    @Column(name = "version_")
    private Integer version;

    /**
     * 数据时间戳
     */
    @Schema(description = "数据时间戳")
    @Column(name = "last_time_")
    private Timestamp lastTime;

}