/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.timeseries;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.community.device.timeseries.DeviceTimeSeriesMetric;
import org.jetlinks.community.timeseries.TimeSeriesMetadata;
import org.jetlinks.community.timeseries.TimeSeriesMetric;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;

class DeviceEventTimeSeriesMetadata
implements TimeSeriesMetadata {
    public final TimeSeriesMetric metric;
    private static final List<PropertyMetadata> defaultMetadata = new ArrayList<PropertyMetadata>();
    private final List<PropertyMetadata> metadata = new ArrayList<PropertyMetadata>(defaultMetadata);

    public DeviceEventTimeSeriesMetadata(String productId, EventMetadata eventMetadata) {
        this.metric = DeviceTimeSeriesMetric.deviceEventMetric(productId, eventMetadata.getId());
        DataType type = eventMetadata.getType();
        if (type instanceof ObjectType) {
            if (CollectionUtils.isNotEmpty((Collection)((ObjectType)type).getProperties())) {
                this.metadata.addAll(((ObjectType)type).getProperties());
            }
        } else {
            SimplePropertyMetadata property = new SimplePropertyMetadata();
            property.setId("value");
            property.setValueType(type);
            property.setName("\u6570\u636e");
            this.metadata.add((PropertyMetadata)property);
        }
    }

    public TimeSeriesMetric getMetric() {
        return this.metric;
    }

    public List<PropertyMetadata> getProperties() {
        return this.metadata;
    }

    static {
        SimplePropertyMetadata property = new SimplePropertyMetadata();
        property.setId("productId");
        property.setValueType((DataType)new StringType());
        property.setName("\u578b\u53f7ID");
        defaultMetadata.add((PropertyMetadata)property);
        property = new SimplePropertyMetadata();
        property.setId("orgId");
        property.setValueType((DataType)new StringType());
        property.setName("\u79df\u6237ID");
        defaultMetadata.add((PropertyMetadata)property);
        property = new SimplePropertyMetadata();
        property.setId("deviceId");
        property.setValueType((DataType)new StringType());
        property.setName("\u8bbe\u5907ID");
        defaultMetadata.add((PropertyMetadata)property);
    }
}

