/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service;

import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.enums.DeviceState;
import org.jetlinks.core.device.DeviceInfo;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceProductOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.ProductInfo;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class AutoDiscoverDeviceRegistry
implements DeviceRegistry {
    private final DeviceRegistry parent;
    private final ReactiveRepository<DeviceInstanceEntity, String> deviceRepository;
    private final ReactiveRepository<DeviceProductEntity, String> productRepository;

    public AutoDiscoverDeviceRegistry(DeviceRegistry parent, ReactiveRepository<DeviceInstanceEntity, String> deviceRepository, ReactiveRepository<DeviceProductEntity, String> productRepository) {
        this.parent = parent;
        this.deviceRepository = deviceRepository;
        this.productRepository = productRepository;
    }

    public Mono<DeviceOperator> getDevice(String deviceId) {
        if (StringUtils.isEmpty((Object)deviceId)) {
            return Mono.empty();
        }
        return Mono.defer(() -> this.parent.getDevice(deviceId).switchIfEmpty(Mono.defer(() -> this.deviceRepository.findById((Object)deviceId).filter(instance -> instance.getState() != DeviceState.notActive).flatMap(instance -> this.parent.register(instance.toDeviceInfo())))));
    }

    public Mono<DeviceProductOperator> getProduct(String productId) {
        if (StringUtils.isEmpty((Object)productId)) {
            return Mono.empty();
        }
        return this.parent.getProduct(productId).switchIfEmpty(Mono.defer(() -> this.productRepository.findById((Object)productId).filter(product -> product.getState() == 1).flatMap(product -> this.parent.register(product.toProductInfo()))));
    }

    public Mono<DeviceOperator> register(DeviceInfo deviceInfo) {
        return this.parent.register(deviceInfo);
    }

    public Mono<DeviceProductOperator> register(ProductInfo productInfo) {
        return this.parent.register(productInfo);
    }

    public Mono<Void> unregisterDevice(String deviceId) {
        return this.parent.unregisterDevice(deviceId);
    }

    public Mono<Void> unregisterProduct(String productId) {
        return this.parent.unregisterProduct(productId);
    }
}

