/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.io.file;

import java.sql.JDBCType;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Table;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.jetlinks.community.io.file.FileInfo;
import org.jetlinks.community.io.file.FileOption;

@Table(name="s_file")
public class FileEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    @Column(nullable=false)
    private String name;
    @Column(nullable=false)
    private String extension;
    @Column(nullable=false)
    private Long length;
    @Column(nullable=false, length=32)
    private String md5;
    @Column(nullable=false, length=64)
    private String sha256;
    @Column(nullable=false)
    @DefaultValue(generator="current_time")
    private Long createTime;
    @Column(length=64)
    private String creatorId;
    @Column(length=64, nullable=false)
    private String serverNodeId;
    @Column(length=512, nullable=false)
    private String storagePath;
    @Column
    @EnumCodec(toMask=true)
    @ColumnType(jdbcType=JDBCType.BIGINT, javaType=Long.class)
    private FileOption[] options;
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR, javaType=String.class)
    private Map<String, Object> others;

    public FileInfo toInfo() {
        return (FileInfo)this.copyTo(new FileInfo(), new String[0]);
    }

    public static FileEntity of(FileInfo fileInfo, String storagePath, String serverNodeId) {
        FileEntity fileEntity = (FileEntity)((Object)new FileEntity().copyFrom(fileInfo, new String[0]));
        fileEntity.setStoragePath(storagePath);
        fileEntity.setServerNodeId(serverNodeId);
        return fileEntity;
    }

    public String getName() {
        return this.name;
    }

    public String getExtension() {
        return this.extension;
    }

    public Long getLength() {
        return this.length;
    }

    public String getMd5() {
        return this.md5;
    }

    public String getSha256() {
        return this.sha256;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public String getServerNodeId() {
        return this.serverNodeId;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public FileOption[] getOptions() {
        return this.options;
    }

    public Map<String, Object> getOthers() {
        return this.others;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setLength(Long length) {
        this.length = length;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }

    public void setSha256(String sha256) {
        this.sha256 = sha256;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setServerNodeId(String serverNodeId) {
        this.serverNodeId = serverNodeId;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public void setOptions(FileOption[] options) {
        this.options = options;
    }

    public void setOthers(Map<String, Object> others) {
        this.others = others;
    }
}

