/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.server.vertx;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.Network;
import org.jetlinks.community.network.NetworkProperties;
import org.jetlinks.community.network.NetworkProvider;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.http.server.vertx.HttpServerConfig;
import org.jetlinks.community.network.http.server.vertx.VertxHttpServer;
import org.jetlinks.community.network.security.CertificateManager;
import org.jetlinks.community.network.security.VertxKeyCertTrustOptions;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DefaultHttpServerProvider
implements NetworkProvider<HttpServerConfig> {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpServerProvider.class);
    private final CertificateManager certificateManager;
    private final Vertx vertx;

    public DefaultHttpServerProvider(CertificateManager certificateManager, Vertx vertx) {
        this.certificateManager = certificateManager;
        this.vertx = vertx;
    }

    @Nonnull
    @Generated
    public NetworkType getType() {
        return DefaultNetworkType.HTTP_SERVER;
    }

    @Nonnull
    public Mono<Network> createNetwork(@Nonnull HttpServerConfig config) {
        VertxHttpServer server = new VertxHttpServer(config);
        return this.initServer(server, config);
    }

    public Mono<Network> reload(@Nonnull Network network, @Nonnull HttpServerConfig config) {
        VertxHttpServer server = (VertxHttpServer)network;
        return this.initServer(server, config);
    }

    protected HttpServer createHttpServer(HttpServerOptions options) {
        return this.vertx.createHttpServer(options);
    }

    @Nullable
    @Generated
    public ConfigMetadata getConfigMetadata() {
        return new DefaultConfigMetadata().add("id", "id", "", (DataType)new StringType()).add("host", "\u672c\u5730\u5730\u5740", "", (DataType)new StringType()).add("port", "\u672c\u5730\u7aef\u53e3", "", (DataType)new IntType()).add("publicHost", "\u516c\u7f51\u5730\u5740", "", (DataType)new StringType()).add("publicPort", "\u516c\u7f51\u7aef\u53e3", "", (DataType)new IntType()).add("certId", "\u8bc1\u4e66id", "", (DataType)new StringType()).add("secure", "\u5f00\u542fTSL", "", (DataType)new BooleanType()).add("httpHeaders", "\u8bf7\u6c42\u5934", "", (DataType)new ObjectType());
    }

    @Nonnull
    public Mono<HttpServerConfig> createConfig(@Nonnull NetworkProperties properties) {
        return (Mono)Mono.defer(() -> {
            HttpServerConfig config = (HttpServerConfig)((Object)((Object)FastBeanCopier.copy((Object)properties.getConfigurations(), (Object)((Object)new HttpServerConfig()), (String[])new String[0])));
            config.setId(properties.getId());
            config.validate();
            return Mono.just((Object)((Object)config));
        }).as(LocaleUtils::transform);
    }

    private Mono<Network> initServer(VertxHttpServer server, HttpServerConfig config) {
        int numberOfInstance = Math.max(1, config.getInstance());
        ArrayList instances = new ArrayList(numberOfInstance);
        return this.convert(config).map(options -> {
            for (int i = 0; i < numberOfInstance; ++i) {
                instances.add(this.createHttpServer((HttpServerOptions)options));
            }
            server.setBindAddress(new InetSocketAddress(config.getHost(), config.getPort()));
            server.setHttpServers(instances);
            for (HttpServer httpServer : instances) {
                this.vertx.nettyEventLoopGroup().execute(() -> httpServer.listen(result -> {
                    if (result.succeeded()) {
                        log.debug("startup http server on [{}]", (Object)server.getBindAddress());
                    } else {
                        server.setLastError(result.cause().getMessage());
                        log.warn("startup http server on [{}] failed", (Object)server.getBindAddress(), (Object)result.cause());
                    }
                }));
            }
            return server;
        });
    }

    private Mono<HttpServerOptions> convert(HttpServerConfig config) {
        HttpServerOptions options = new HttpServerOptions();
        options.setHandle100ContinueAutomatically(true);
        options.setHost(config.getHost());
        options.setPort(config.getPort());
        if (config.isSecure()) {
            options.setSsl(true);
            return this.certificateManager.getCertificate(config.getCertId()).map(VertxKeyCertTrustOptions::new).doOnNext(arg_0 -> ((HttpServerOptions)options).setKeyCertOptions(arg_0)).doOnNext(arg_0 -> ((HttpServerOptions)options).setTrustOptions(arg_0)).thenReturn((Object)options);
        }
        return Mono.just((Object)options);
    }
}

