/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.external.socket;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.ReactiveAuthenticationManager;
import org.hswebframework.web.authorization.token.UserToken;
import org.hswebframework.web.authorization.token.UserTokenManager;
import org.hswebframework.web.logger.ReactiveLogger;
import org.jetlinks.community.gateway.external.Message;
import org.jetlinks.community.gateway.external.MessagingManager;
import org.jetlinks.community.gateway.external.SubscribeRequest;
import org.jetlinks.community.gateway.external.socket.MessagingRequest;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.socket.CloseStatus;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.WebSocketMessage;
import org.springframework.web.reactive.socket.WebSocketSession;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

public class WebSocketMessagingHandler
implements WebSocketHandler {
    private static final Logger log = LoggerFactory.getLogger(WebSocketMessagingHandler.class);
    private final MessagingManager messagingManager;
    private final UserTokenManager userTokenManager;
    private final ReactiveAuthenticationManager authenticationManager;

    @Nonnull
    public Mono<Void> handle(@Nonnull WebSocketSession session) {
        String[] path = session.getHandshakeInfo().getUri().getPath().split("[/]");
        if (path.length == 0) {
            return session.send((Publisher)Mono.just((Object)session.textMessage(JSON.toJSONString((Object)Message.error("auth", null, "\u9519\u8bef\u7684\u8bf7\u6c42"))))).then(session.close(CloseStatus.BAD_DATA));
        }
        String token = path[path.length - 1];
        ConcurrentHashMap subs = new ConcurrentHashMap();
        return this.userTokenManager.getByToken(token).map(UserToken::getUserId).flatMap(arg_0 -> ((ReactiveAuthenticationManager)this.authenticationManager).getByUserId(arg_0)).switchIfEmpty(session.send((Publisher)Mono.just((Object)session.textMessage(JSON.toJSONString((Object)Message.authError())))).then(session.close(CloseStatus.BAD_DATA)).then(Mono.empty())).flatMap(auth -> session.receive().doOnNext(message -> {
            try {
                if (message.getType() == WebSocketMessage.Type.PONG) {
                    return;
                }
                if (message.getType() == WebSocketMessage.Type.PING) {
                    session.send((Publisher)Mono.just((Object)session.pongMessage(DataBufferFactory::allocateBuffer))).subscribe();
                    return;
                }
                MessagingRequest request = (MessagingRequest)JSON.parseObject((String)message.getPayloadAsText(), MessagingRequest.class);
                if (request == null) {
                    return;
                }
                if (request.getType() == MessagingRequest.Type.ping) {
                    session.send((Publisher)Mono.just((Object)session.textMessage(JSON.toJSONString((Object)Message.pong(request.getId()))))).subscribe();
                    return;
                }
                if (StringUtils.isEmpty((Object)request.getId())) {
                    session.send((Publisher)Mono.just((Object)session.textMessage(JSON.toJSONString((Object)Message.error(request.getType().name(), null, "id\u4e0d\u80fd\u4e3a\u7a7a"))))).subscribe();
                    return;
                }
                if (request.getType() == MessagingRequest.Type.sub) {
                    Disposable old = (Disposable)subs.get(request.getId());
                    if (old != null && !old.isDisposed()) {
                        return;
                    }
                    HashMap<String, String> context = new HashMap<String, String>();
                    context.put("userId", auth.getUser().getId());
                    context.put("userName", auth.getUser().getName());
                    Disposable sub = this.messagingManager.subscribe(SubscribeRequest.of(request, auth)).doOnEach(ReactiveLogger.onError(err -> log.error("{}", (Object)err.getMessage(), err))).onErrorResume(err -> Mono.just((Object)Message.error(request.getId(), request.getTopic(), err))).map(msg -> session.textMessage(JSON.toJSONString((Object)msg))).doOnComplete(() -> {
                        log.debug("complete subscription:{}", (Object)request.getTopic());
                        subs.remove(request.getId());
                        ((Mono)Mono.just((Object)session.textMessage(JSON.toJSONString((Object)Message.complete(request.getId())))).as(arg_0 -> ((WebSocketSession)session).send(arg_0))).subscribe();
                    }).doOnCancel(() -> {
                        log.debug("cancel subscription:{}", (Object)request.getTopic());
                        subs.remove(request.getId());
                    }).transform(arg_0 -> ((WebSocketSession)session).send(arg_0)).subscriberContext(ReactiveLogger.start(context)).subscriberContext(Context.of(Authentication.class, (Object)auth)).subscribe();
                    if (!sub.isDisposed()) {
                        subs.put(request.getId(), sub);
                    }
                } else if (request.getType() == MessagingRequest.Type.unsub) {
                    Optional.ofNullable(subs.remove(request.getId())).ifPresent(Disposable::dispose);
                } else {
                    session.send((Publisher)Mono.just((Object)session.textMessage(JSON.toJSONString((Object)Message.error(request.getId(), request.getTopic(), "\u4e0d\u652f\u6301\u7684\u7c7b\u578b:" + (Object)((Object)request.getType())))))).subscribe();
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage(), (Throwable)e);
                session.send((Publisher)Mono.just((Object)session.textMessage(JSON.toJSONString((Object)Message.error("illegal_argument", null, "\u6d88\u606f\u683c\u5f0f\u9519\u8bef"))))).subscribe();
            }
        }).then()).doFinally(r -> {
            subs.values().forEach(Disposable::dispose);
            subs.clear();
        });
    }

    public WebSocketMessagingHandler(MessagingManager messagingManager, UserTokenManager userTokenManager, ReactiveAuthenticationManager authenticationManager) {
        this.messagingManager = messagingManager;
        this.userTokenManager = userTokenManager;
        this.authenticationManager = authenticationManager;
    }
}

