package net.zstong.awump.monitoring.entity;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Getter;
import lombok.Setter;
import net.zstong.awump.base.entity.AwWarehouseEntity;
import net.zstong.awump.base.entity.AwWarehouseInfo;
import net.zstong.awump.base.entity.BaseEntity;
import org.hswebframework.ezorm.rdb.mapping.annotation.Comment;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.validator.CreateGroup;
import org.springframework.beans.BeanUtils;

import javax.persistence.Column;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import java.time.LocalDate;

/**
 * @author yuanhc
 * @date 2023-07-07
 */
@Getter
@Setter
@Comment("监控设备信息")
public class AwMonitoringDeviceInfo extends BaseEntity<String> {

    /**
     * 所属单位
     */
    @Schema(description = "所属单位")
    private String institutionId;


    /**
     * 所属库房
     */
    @Schema(description = "所属库房")
    private String warehouseId;

    private AwWarehouseEntity warehouse;


    /**
     * 所属监控区域
     */
    @Schema(description = "所属监控区域")
    private String areaId;

    private AwMonitoringAreaEntity area;


    /**
     * 设备名称
     */
    @Schema(description = "设备名称")
    private String name;


    /**
     * 设备编码
     */
    @Schema(description = "设备编码")
    private String code;


    /**
     * 设备类别
     */
    @Schema(description = "设备类别")
    private String deviceType;


    /**
     * 设备型号
     */
    @Schema(description = "设备型号")
    private String model;


    /**
     * 品牌
     */
    @Schema(description = "品牌")
    private String brand;


    /**
     * 访问地址
     */
    @Schema(description = "访问地址")
    private String serverAddr;


    /**
     * IP地址
     */
    @Schema(description = "IP地址")
    private String ip;


    /**
     * 访问用户名
     */
    @Schema(description = "访问用户名")
    private String username;


    /**
     * 访问密码
     */
    @Schema(description = "访问密码")
    private String pwd;


    /**
     * 设备序号
     */
    @Schema(description = "设备序号")
    private String deviceSn;

    private String parentId;

    /**
     * 出厂日期
     */
    @Schema(description = "出厂日期")
    private LocalDate manufactureDate;

    public static AwMonitoringDeviceInfo of(AwMonitoringDeviceEntity entity) {
        AwMonitoringDeviceInfo info = new AwMonitoringDeviceInfo();
        BeanUtils.copyProperties(entity, info);
        return info;
    }

}