/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.service.data;

import org.jetlinks.community.device.service.data.DeviceDataStorageProperties;
import org.jetlinks.community.device.service.data.ThingsBridgingDeviceDataService;
import org.jetlinks.community.device.timeseries.DeviceTimeSeriesMetric;
import org.jetlinks.community.things.data.ThingsDataContext;
import org.jetlinks.community.things.data.ThingsDataCustomizer;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.springframework.stereotype.Component;

@Component
public class DeviceThingsDataCustomizer
implements ThingsDataCustomizer {
    private final DeviceDataStorageProperties properties;

    public void custom(ThingsDataContext context) {
        context.customMetricBuilder(ThingsBridgingDeviceDataService.thingType, new MetricBuilder(){

            public String getThingIdProperty() {
                return "deviceId";
            }

            public String createLogMetric(String thingType, String thingTemplateId, String thingId) {
                return DeviceTimeSeriesMetric.deviceLogMetricId(thingTemplateId);
            }

            public String createPropertyMetric(String thingType, String thingTemplateId, String thingId) {
                return DeviceTimeSeriesMetric.devicePropertyMetricId(thingTemplateId);
            }

            public String createEventAllInOneMetric(String thingType, String thingTemplateId, String thingId) {
                return super.createEventAllInOneMetric(thingType, thingTemplateId, thingId);
            }

            public String createEventMetric(String thingType, String thingTemplateId, String thingId, String eventId) {
                return DeviceTimeSeriesMetric.deviceEventMetricId(thingTemplateId, eventId);
            }
        });
        context.setDefaultPolicy(this.properties.getDefaultPolicy());
        context.customSettings(ThingsBridgingDeviceDataService.thingType, (DataSettings)this.properties);
    }

    public DeviceThingsDataCustomizer(DeviceDataStorageProperties properties) {
        this.properties = properties;
    }
}

