/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.message;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hswebframework.web.logger.ReactiveLogger;
import org.jetlinks.community.PropertyMetadataConstants;
import org.jetlinks.community.device.message.DeviceMessageConnector;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.enums.ErrorCode;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.core.exception.DeviceOperationException;
import org.jetlinks.core.message.ChildDeviceMessage;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.Headers;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.RepayableDeviceMessage;
import org.jetlinks.core.message.function.FunctionInvokeMessage;
import org.jetlinks.core.message.function.FunctionParameter;
import org.jetlinks.core.message.interceptor.DeviceMessageSenderInterceptor;
import org.jetlinks.core.message.property.WritePropertyMessage;
import org.jetlinks.core.message.property.WritePropertyMessageReply;
import org.jetlinks.core.metadata.FunctionMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.ValidateResult;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class DeviceMessageSendLogInterceptor
implements DeviceMessageSenderInterceptor {
    private static final Logger log = LoggerFactory.getLogger((String)"system.device.message.sender");
    private final EventBus eventBus;
    private final DeviceRegistry registry;

    public Mono<Void> doPublish(Message message) {
        Mono<Void> then = Mono.empty();
        if (message.getHeader(Headers.dispatchToParent).orElse(false).booleanValue()) {
            return then;
        }
        if (message instanceof ChildDeviceMessage) {
            then = this.doPublish(((ChildDeviceMessage)message).getChildDeviceMessage());
        }
        return DeviceMessageConnector.createDeviceMessageTopic(this.registry, message).flatMap(topic -> this.eventBus.publish(topic, (Object)message)).then(then);
    }

    private Mono<DeviceMessage> convertParameterType(DeviceOperator device, FunctionInvokeMessage message) {
        if (message.getHeader(Headers.force).orElse(false).booleanValue()) {
            return Mono.just((Object)message);
        }
        return device.getMetadata().doOnNext(metadata -> {
            FunctionMetadata function = (FunctionMetadata)metadata.getFunction(message.getFunctionId()).orElseThrow(() -> new DeviceOperationException(ErrorCode.FUNCTION_UNDEFINED, "\u529f\u80fd[" + message.getFunctionId() + "]\u672a\u5b9a\u4e49"));
            Map parameters = message.getInputs().stream().collect(Collectors.toMap(FunctionParameter::getName, Function.identity()));
            message.addHeaderIfAbsent(Headers.async, (Object)function.isAsync());
            for (PropertyMetadata input : function.getInputs()) {
                FunctionParameter parameter = (FunctionParameter)parameters.get(input.getId());
                if (parameter == null) continue;
                ValidateResult result = input.getValueType().validate(parameter.getValue());
                parameter.setValue(result.assertSuccess());
            }
        }).thenReturn((Object)message);
    }

    private Mono<DeviceMessage> prepareMessage(DeviceOperator device, DeviceMessage message) {
        Map properties;
        if (message instanceof FunctionInvokeMessage) {
            return this.convertParameterType(device, (FunctionInvokeMessage)message);
        }
        if (message instanceof WritePropertyMessage && (properties = ((WritePropertyMessage)message).getProperties()).size() == 1) {
            String property = (String)properties.keySet().iterator().next();
            return device.getMetadata().doOnNext(metadata -> metadata.getProperty(property).filter(PropertyMetadataConstants.Source::isManual).ifPresent(ignore -> message.addHeader(PropertyMetadataConstants.Source.headerKey, (Object)"manual"))).thenReturn((Object)message);
        }
        return Mono.just((Object)message);
    }

    public <R extends DeviceMessage> Flux<R> afterSent(DeviceOperator device, DeviceMessage message, Flux<R> reply) {
        if (PropertyMetadataConstants.Source.isManual((DeviceMessage)message) && message instanceof WritePropertyMessage) {
            WritePropertyMessageReply messageReply = ((WritePropertyMessage)message).newReply();
            PropertyMetadataConstants.Source.setManual((DeviceMessage)messageReply);
            ((WritePropertyMessage)message).getProperties().forEach((arg_0, arg_1) -> ((WritePropertyMessageReply)messageReply).addProperty(arg_0, arg_1));
            return this.doPublish((Message)messageReply).thenMany((Publisher)Flux.just((Object)messageReply)).map(r -> r);
        }
        return reply;
    }

    public Mono<DeviceMessage> preSend(DeviceOperator device, DeviceMessage message) {
        if (message instanceof RepayableDeviceMessage) {
            return this.prepareMessage(device, message).flatMap(msg -> this.doPublish((Message)msg).thenReturn(msg).doOnEach(ReactiveLogger.onComplete(() -> {
                if (log.isDebugEnabled()) {
                    log.debug("\u5411\u8bbe\u5907[{}]\u53d1\u9001\u6307\u4ee4:{}", (Object)msg.getDeviceId(), (Object)msg.toString());
                }
            })));
        }
        return Mono.just((Object)message);
    }

    public DeviceMessageSendLogInterceptor(EventBus eventBus, DeviceRegistry registry) {
        this.eventBus = eventBus;
        this.registry = registry;
    }
}

