/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.auth.entity.UserSettingEntity;
import org.jetlinks.community.auth.service.UserSettingService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/user/settings"})
@Tag(name="\u7528\u6237\u4e2a\u4eba\u8bbe\u7f6e")
public class UserSettingController {
    private final UserSettingService settingService;

    @GetMapping(value={"/{type}"})
    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b\u7684\u5168\u90e8\u914d\u7f6e\u4fe1\u606f")
    public Flux<UserSettingEntity> getCurrentUserSettings(@PathVariable String type) {
        return Authentication.currentReactive().flatMapMany(auth -> ((ReactiveQuery)((ReactiveQuery)this.settingService.createQuery().where(UserSettingEntity::getUserId, (Object)auth.getUser().getId())).and(UserSettingEntity::getType, (Object)type)).fetch());
    }

    @GetMapping(value={"/{type}/{key}"})
    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b\u7684\u5355\u4e2a\u914d\u7f6e\u4fe1\u606f")
    public Mono<UserSettingEntity> getCurrentUserSettings(@PathVariable String type, @PathVariable String key) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> this.settingService.findById(UserSettingEntity.generateId(auth.getUser().getId(), type, key)));
    }

    @PostMapping(value={"/{type}"})
    @Operation(summary="\u521b\u5efa\u6307\u5b9a\u7c7b\u578b\u7684\u914d\u7f6e\u4fe1\u606f")
    public Mono<Void> createSetting(@PathVariable String type, @RequestBody Mono<UserSettingEntity> body) {
        return this.saveSetting(type, (String)IDGenerator.MD5.generate(), body);
    }

    @PatchMapping(value={"/{type}/{key}"})
    @Operation(summary="\u4fdd\u5b58\u6307\u5b9a\u7c7b\u578b\u7684\u914d\u7f6e\u4fe1\u606f")
    public Mono<Void> saveSetting(@PathVariable String type, @PathVariable String key, @RequestBody Mono<UserSettingEntity> body) {
        return ((Mono)Mono.zip((Mono)Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)), body, (auth, entity) -> {
            entity.setUserId(auth.getUser().getId());
            entity.setType(type);
            entity.setKey(key);
            entity.generateId();
            return entity;
        }).as(arg_0 -> ((UserSettingService)this.settingService).save(arg_0))).then();
    }

    @DeleteMapping(value={"/{type}/{key}"})
    @Operation(summary="\u5220\u9664\u6307\u5b9a\u7c7b\u578b\u7684\u914d\u7f6e\u4fe1\u606f")
    public Mono<Void> deleteSetting(@PathVariable String type, @PathVariable String key) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMap(auth -> this.settingService.deleteById(UserSettingEntity.generateId(auth.getUser().getId(), type, key))).then();
    }

    public UserSettingController(UserSettingService settingService) {
        this.settingService = settingService;
    }
}

