/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.defaults.SaveResult;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.GenericTreeSortSupportEntity;
import org.hswebframework.web.api.crud.entity.QueryNoPagingOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.api.crud.entity.TreeUtils;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.authorization.exception.UnAuthorizedException;
import org.hswebframework.web.crud.service.ReactiveCrudService;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.i18n.LocaleUtils;
import org.hswebframework.web.system.authorization.defaults.service.DefaultPermissionService;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.community.auth.configuration.MenuProperties;
import org.jetlinks.community.auth.entity.MenuEntity;
import org.jetlinks.community.auth.entity.MenuView;
import org.jetlinks.community.auth.service.DefaultMenuService;
import org.jetlinks.community.auth.service.MenuGrantService;
import org.jetlinks.community.auth.service.request.MenuGrantRequest;
import org.jetlinks.community.auth.web.request.AuthorizationSettingDetail;
import org.jetlinks.community.web.response.ValidationResult;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/menu"})
@Authorize
@Resource(id="menu", name="\u83dc\u5355\u7ba1\u7406", group={"system"})
@Tag(name="\u83dc\u5355\u7ba1\u7406")
public class MenuController
implements ReactiveServiceCrudController<MenuEntity, String> {
    private final DefaultMenuService defaultMenuService;
    private final MenuGrantService grantService;
    private final MenuProperties properties;
    private final DefaultPermissionService permissionService;

    public ReactiveCrudService<MenuEntity, String> getService() {
        return this.defaultMenuService;
    }

    @QueryAction
    @PostMapping(value={"/_all/tree"})
    @Operation(summary="\u83b7\u53d6\u83b7\u53d6\u5168\u90e8\u83dc\u5355\u4fe1\u606f\uff08\u6811\u7ed3\u6784\uff09")
    public Flux<MenuEntity> getAllMenuAsTree(@RequestBody Mono<QueryParamEntity> queryMono) {
        return queryMono.doOnNext(query -> query.toQuery().orderByAsc(GenericTreeSortSupportEntity::getSortIndex).noPaging()).flatMapMany(arg_0 -> ((DefaultMenuService)this.defaultMenuService).query(arg_0)).collectList().flatMapIterable(list -> TreeSupportEntity.list2tree((Collection)list, MenuEntity::setChildren));
    }

    @PostMapping(value={"/user-own/tree"})
    @Authorize(merge=false)
    @Operation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u53ef\u8bbf\u95ee\u7684\u83dc\u5355(\u6811\u7ed3\u6784)")
    public Flux<MenuView> getUserMenuAsTree(@RequestBody(required=false) Mono<QueryParamEntity> queryMono) {
        return queryMono.flatMapMany(queryParam -> (Flux)this.getUserMenuAsList((QueryParamEntity)queryParam).as(MenuController::listToTree));
    }

    @GetMapping(value={"/user-own/tree"})
    @Authorize(merge=false)
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u53ef\u8bbf\u95ee\u7684\u83dc\u5355(\u6811\u7ed3\u6784)")
    public Flux<MenuView> getUserMenuAsTree(QueryParamEntity queryParam) {
        return (Flux)this.getUserMenuAsList(queryParam).as(MenuController::listToTree);
    }

    @GetMapping(value={"/user-own/list"})
    @Authorize(merge=false)
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u5f53\u524d\u7528\u6237\u53ef\u8bbf\u95ee\u7684\u83dc\u5355(\u5217\u8868\u7ed3\u6784)")
    public Flux<MenuView> getUserMenuAsList(QueryParamEntity queryParam) {
        return Authentication.currentReactive().switchIfEmpty(Mono.error(UnAuthorizedException::new)).flatMapMany(autz -> this.properties.isAllowAllMenu((Authentication)autz) ? this.defaultMenuService.getMenuViews(queryParam, menu -> true).doOnNext(MenuView::grantAll) : this.defaultMenuService.getGrantedMenus(queryParam, autz.getDimensions()));
    }

    @Authorize(ignore=true)
    @PostMapping(value={"/owner"})
    @Operation(summary="\u83b7\u53d6\u83dc\u5355\u6240\u5c5e\u7cfb\u7edf")
    public Flux<String> getSystemMenuOwner(@RequestBody @Parameter(description="\u9700\u8981\u53bb\u9664\u7684\u6240\u5c5e\u7cfb\u7edf\uff0c\u4f8b\u5982\u5f53\u524d\u7cfb\u7edf") Mono<List<String>> excludes) {
        return excludes.flatMapMany(owner -> ((ReactiveQuery)this.defaultMenuService.createQuery().and(MenuEntity::getOwner, "nin", owner)).fetch()).map(MenuEntity::getOwner).distinct();
    }

    @Authorize(ignore=true)
    @PostMapping(value={"/owner/tree/{owner}"})
    @Operation(summary="\u83b7\u53d6\u672c\u7cfb\u7edf\u83dc\u5355\u4fe1\u606f\uff08\u6811\u7ed3\u6784\uff09")
    public Flux<MenuEntity> getSystemMenuAsTree(@PathVariable @Parameter(description="\u83dc\u5355\u6240\u5c5e\u7cfb\u7edf") String owner, @RequestBody Mono<QueryParamEntity> queryMono) {
        return queryMono.doOnNext(query -> ((Query)query.toQuery().and(MenuEntity::getOwner, (Object)owner)).orderByAsc(GenericTreeSortSupportEntity::getSortIndex).noPaging()).flatMapMany(arg_0 -> ((DefaultMenuService)this.defaultMenuService).query(arg_0)).collectList().flatMapIterable(list -> TreeSupportEntity.list2tree((Collection)list, MenuEntity::setChildren));
    }

    @PutMapping(value={"/{targetType}/{targetId}/_grant"})
    @Operation(summary="\u5bf9\u83dc\u5355\u8fdb\u884c\u6388\u6743")
    @ResourceAction(id="grant", name="\u6388\u6743")
    public Mono<Void> grant(@PathVariable String targetType, @PathVariable String targetId, @RequestBody Mono<MenuGrantRequest> body) {
        return body.doOnNext(request -> {
            request.setTargetType(targetType);
            request.setTargetId(targetId);
        }).flatMap(this.grantService::grant);
    }

    @PutMapping(value={"/_batch/_grant"})
    @Operation(summary="\u5bf9\u83dc\u5355\u6279\u91cf\u8fdb\u884c\u6388\u6743")
    @ResourceAction(id="grant", name="\u6388\u6743")
    public Mono<Void> grant(@RequestBody Flux<MenuGrantRequest> body) {
        return body.flatMap(this.grantService::grant).then();
    }

    @GetMapping(value={"/{targetType}/{targetId}/_grant/tree"})
    @ResourceAction(id="grant", name="\u6388\u6743")
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u83dc\u5355\u6388\u6743\u4fe1\u606f(\u6811\u7ed3\u6784)")
    public Flux<MenuView> getGrantInfoTree(@PathVariable String targetType, @PathVariable String targetId, QueryParamEntity query) {
        return (Flux)this.getGrantInfo(targetType, targetId, query).as(MenuController::listToTree);
    }

    @GetMapping(value={"/{targetType}/{targetId}/_grant/list"})
    @ResourceAction(id="grant", name="\u6388\u6743")
    @QueryNoPagingOperation(summary="\u83b7\u53d6\u83dc\u5355\u6388\u6743\u4fe1\u606f(\u5217\u8868\u7ed3\u6784)")
    public Flux<MenuView> getGrantInfo(@PathVariable String targetType, @PathVariable String targetId, QueryParamEntity query) {
        Flux allMenu = this.getUserMenuAsList(query).cache();
        return Mono.zip((Mono)this.defaultMenuService.getGrantedMenus(targetType, targetId).collectMap(GenericEntity::getId), (Mono)allMenu.collectMap(GenericEntity::getId, Function.identity()), (granted, all) -> LocaleUtils.currentReactive().flatMapMany(locale -> allMenu.doOnNext(MenuView::resetGrant).map(view -> view.withGranted((MenuView)((Object)((Object)((Object)((Object)granted.get(view.getId()))))))))).flatMapMany(Function.identity());
    }

    @PostMapping(value={"/permissions"})
    @ResourceAction(id="grant", name="\u6388\u6743")
    @Operation(summary="\u6839\u636e\u83dc\u5355\u83b7\u53d6\u5bf9\u5e94\u7684\u6743\u9650")
    public Flux<AuthorizationSettingDetail.PermissionInfo> getPermissionsByMenuGrant(@RequestBody Flux<MenuView> menus) {
        return this.getAuthorizationSettingDetail(menus).flatMapIterable(AuthorizationSettingDetail::getPermissionList);
    }

    @GetMapping(value={"/asset-types"})
    @ResourceAction(id="grant", name="\u6388\u6743")
    @Operation(summary="\u6839\u636e\u83dc\u5355\u83b7\u53d6\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u578b")
    @Deprecated
    public Flux<AssetTypeView> getAssetTypeByMenuGrant() {
        return Flux.just((Object[])new AssetTypeView[]{AssetTypeView.of("sys", "\u7cfb\u7edf\u8d44\u6e90"), AssetTypeView.of("org", "\u7ec4\u7ec7\u8d44\u6e90"), AssetTypeView.of("warehouse", "\u5e93\u623f\u8d44\u6e90")});
    }

    @PatchMapping(value={"/{owner}/_all"})
    @SaveAction
    @Transactional
    @Operation(summary="\u4fdd\u5b58\u4e00\u4e2a\u5e94\u7528\u4e0b\u7684\u5168\u91cf\u6570\u636e", description="\u5148\u5e94\u7528\u4e0b\u5168\u90e8\u5220\u9664\u65e7\u6570\u636e\uff0c\u518d\u65b0\u589e\u6570\u636e")
    public Mono<SaveResult> saveOwnerAll(@PathVariable String owner, @RequestBody Flux<MenuEntity> menus) {
        return ((ReactiveDelete)((ReactiveDelete)this.getService().createDelete().where(MenuEntity::getStatus, (Object)1)).and(MenuEntity::getOwner, (Object)owner)).execute().then(this.save(menus));
    }

    @GetMapping(value={"/code/_validate"})
    @QueryAction
    @Operation(summary="\u9a8c\u8bc1\u83dc\u5355\u7f16\u7801\u662f\u5426\u5408\u6cd5", description="\u540c\u4e00\u6240\u6709\u8005\u7684\u76f8\u540c\u5e94\u7528\u4e0b\u7684\u83dc\u5355\uff0c\u7f16\u7801\u4e0d\u80fd\u91cd\u590d")
    public Mono<ValidationResult> codeValidate(@RequestParam @Parameter(description="\u83dc\u5355\u7f16\u7801") String code, @RequestParam @Parameter(description="\u83dc\u5355\u6240\u6709\u8005") String owner) {
        System.out.println("==========code==================" + code);
        return LocaleUtils.currentReactive().flatMap(locale -> {
            MenuEntity entity = new MenuEntity();
            entity.setCode(code);
            entity.setOwner(owner);
            entity.tryValidate("code", new Class[]{CreateGroup.class});
            System.out.println((String)entity.getId() + "==========entity==================" + (Object)((Object)entity));
            return this.defaultMenuService.countMenuBy(code, owner).map(count -> {
                System.out.println((String)entity.getId() + "==========count==================" + count);
                if (count > 0) {
                    return ValidationResult.error((String)LocaleUtils.resolveMessage((String)"error.id_already_exists", (Object[])new Object[]{locale}));
                }
                return ValidationResult.success();
            });
        }).defaultIfEmpty((Object)ValidationResult.success()).onErrorResume(ValidationException.class, e -> Mono.just((Object)e.getI18nCode()).map(ValidationResult::error));
    }

    private Mono<AuthorizationSettingDetail> getAuthorizationSettingDetail(Flux<MenuView> menus) {
        return Mono.zip((Mono)menus.doOnNext(view -> {
            view.setGranted(true);
            if (null != view.getButtons()) {
                for (MenuView.ButtonView button : view.getButtons()) {
                    button.setGranted(true);
                }
            }
        }).collectList().map(list -> {
            MenuGrantRequest request = new MenuGrantRequest();
            request.setTargetType("temp");
            request.setTargetId("temp");
            request.setMenus((List<MenuView>)list);
            return request;
        }), (Mono)this.defaultMenuService.createQuery().fetch().collectList(), MenuGrantRequest::toAuthorizationSettingDetail);
    }

    private static Flux<MenuView> listToTree(Flux<MenuView> flux) {
        return flux.collectList().flatMapIterable(list -> TreeUtils.list2tree((Collection)list, GenericEntity::getId, MenuView::getParentId, MenuView::setChildren));
    }

    public MenuController(DefaultMenuService defaultMenuService, MenuGrantService grantService, MenuProperties properties, DefaultPermissionService permissionService) {
        this.defaultMenuService = defaultMenuService;
        this.grantService = grantService;
        this.properties = properties;
        this.permissionService = permissionService;
    }

    public static class AssetTypeView {
        private String id;
        private String name;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        private AssetTypeView(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public static AssetTypeView of(String id, String name) {
            return new AssetTypeView(id, name);
        }

        public AssetTypeView() {
        }
    }
}

