/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.service.request;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.TreeSupportEntity;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.auth.entity.MenuBindEntity;
import org.jetlinks.community.auth.entity.MenuEntity;
import org.jetlinks.community.auth.entity.MenuView;
import org.jetlinks.community.auth.entity.PermissionInfo;
import org.jetlinks.community.auth.web.request.AuthorizationSettingDetail;
import org.springframework.util.StringUtils;

public class MenuGrantRequest {
    @Schema(description="\u6743\u9650\u7c7b\u578b,\u5982: org,openApi")
    private String targetType;
    @Schema(description="\u6743\u9650\u7c7b\u578b\u5bf9\u5e94\u7684\u6570\u636eID")
    private String targetId;
    @Schema(description="\u51b2\u7a81\u65f6\u662f\u5426\u5408\u5e76")
    private boolean merge = true;
    @Schema(description="\u51b2\u7a81\u65f6\u5408\u5e76\u4f18\u5148\u7ea7")
    private int priority = 10;
    @Schema(description="\u6388\u6743\u7684\u83dc\u5355\u4fe1\u606f")
    private List<MenuView> menus;

    public AuthorizationSettingDetail toAuthorizationSettingDetail(List<MenuEntity> menuEntities) {
        Map menuMap = menuEntities.stream().collect(Collectors.toMap(GenericEntity::getId, Function.identity()));
        AuthorizationSettingDetail detail = new AuthorizationSettingDetail();
        detail.setTargetType(this.targetType);
        detail.setTargetId(this.targetId);
        detail.setMerge(this.merge);
        detail.setPriority(this.priority);
        ConcurrentHashMap<String, Set> permissionInfos = new ConcurrentHashMap<String, Set>();
        for (MenuView menu : this.menus) {
            List expand = TreeSupportEntity.expandTree2List((TreeSupportEntity)menu, (IDGenerator)IDGenerator.MD5);
            for (MenuView menuView : expand) {
                MenuEntity entity;
                if (!menu.isGranted() || (entity = (MenuEntity)((Object)menuMap.get(menuView.getId()))) == null) continue;
                if (CollectionUtils.isNotEmpty(entity.getPermissions())) {
                    for (PermissionInfo permission : entity.getPermissions()) {
                        if (!StringUtils.hasText((String)permission.getPermission()) || !CollectionUtils.isNotEmpty(permission.getActions())) continue;
                        permissionInfos.computeIfAbsent(permission.getPermission(), ignore -> new HashSet()).addAll(permission.getActions());
                    }
                }
                if (!CollectionUtils.isNotEmpty(menuView.getButtons())) continue;
                for (MenuView.ButtonView button : menuView.getButtons()) {
                    if (!button.isGranted()) continue;
                    entity.getButton(button.getId()).ifPresent(buttonInfo -> {
                        if (CollectionUtils.isNotEmpty(buttonInfo.getPermissions())) {
                            for (PermissionInfo permission : buttonInfo.getPermissions()) {
                                if (CollectionUtils.isEmpty(permission.getActions())) continue;
                                permissionInfos.computeIfAbsent(permission.getPermission(), ignore -> new HashSet()).addAll(permission.getActions());
                            }
                        }
                    });
                }
            }
        }
        detail.setPermissionList(permissionInfos.entrySet().stream().map(e -> AuthorizationSettingDetail.PermissionInfo.of((String)e.getKey(), (Collection)e.getValue())).collect(Collectors.toList()));
        return detail;
    }

    public List<MenuBindEntity> toBindEntities() {
        if (CollectionUtils.isEmpty(this.menus)) {
            return Collections.emptyList();
        }
        ArrayList entities = new ArrayList();
        for (MenuView menu2 : this.menus) {
            TreeSupportEntity.expandTree2List((TreeSupportEntity)menu2, entities, (IDGenerator)IDGenerator.MD5);
        }
        return entities.stream().filter(MenuView::isGranted).map(menu -> MenuBindEntity.of(menu).withTarget(this.targetType, this.targetId).withMerge(this.merge, this.priority)).collect(Collectors.toList());
    }

    public String getTargetType() {
        return this.targetType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public int getPriority() {
        return this.priority;
    }

    public List<MenuView> getMenus() {
        return this.menus;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public void setTargetId(String targetId) {
        this.targetId = targetId;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public void setMenus(List<MenuView> menus) {
        this.menus = menus;
    }

    public MenuGrantRequest(String targetType, String targetId, boolean merge, int priority, List<MenuView> menus) {
        this.targetType = targetType;
        this.targetId = targetId;
        this.merge = merge;
        this.priority = priority;
        this.menus = menus;
    }

    public MenuGrantRequest() {
    }
}

