/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.service;

import java.util.Collection;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.web.authorization.DefaultDimensionType;
import org.hswebframework.web.crud.service.GenericReactiveCrudService;
import org.hswebframework.web.system.authorization.defaults.service.DefaultDimensionUserService;
import org.jetlinks.community.auth.entity.RoleEntity;
import org.jetlinks.community.auth.utils.DimensionUserBindUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Mono;

@Service
public class RoleService
extends GenericReactiveCrudService<RoleEntity, String> {
    private final DefaultDimensionUserService dimensionUserService;

    @Transactional
    public Mono<Void> bindUser(@NotNull Collection<String> userIdList, @Nullable Collection<String> roleIdList, boolean removeOldBind) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Mono.empty();
        }
        return DimensionUserBindUtils.bindUser(this.dimensionUserService, userIdList, DefaultDimensionType.role.getId(), roleIdList, removeOldBind);
    }

    @Transactional
    public Mono<Void> unbindUser(@NotNull Collection<String> userIdList, @Nullable Collection<String> roleIdList) {
        if (CollectionUtils.isEmpty(userIdList)) {
            return Mono.empty();
        }
        return DimensionUserBindUtils.unbindUser(this.dimensionUserService, userIdList, DefaultDimensionType.role.getId(), roleIdList);
    }

    public RoleService(DefaultDimensionUserService dimensionUserService) {
        this.dimensionUserService = dimensionUserService;
    }
}

