/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.service;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.rdb.mapping.ReactiveDelete;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.DimensionProvider;
import org.hswebframework.web.authorization.DimensionType;
import org.hswebframework.web.system.authorization.api.entity.AuthorizationSettingEntity;
import org.hswebframework.web.system.authorization.api.event.ClearUserAuthorizationCacheEvent;
import org.hswebframework.web.system.authorization.defaults.configuration.PermissionProperties;
import org.hswebframework.web.system.authorization.defaults.service.DefaultAuthorizationSettingService;
import org.jetlinks.community.auth.web.request.AuthorizationSettingDetail;
import org.reactivestreams.Publisher;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

@Component
public class AuthorizationSettingDetailService {
    private final DefaultAuthorizationSettingService settingService;
    private final List<DimensionProvider> providers;
    private final PermissionProperties permissionProperties;
    private final ApplicationEventPublisher eventPublisher;

    public Mono<Void> clearPermissionUserAuth(String type, String id) {
        return Flux.fromIterable(this.providers).flatMap(provider -> provider.getAllType().map(DimensionType::getId).map(t -> Tuples.of((Object)t, (Object)provider))).collectMap(Tuple2::getT1, Tuple2::getT2).flatMapMany(typeProviderMapping -> Mono.justOrEmpty(typeProviderMapping.get(type)).flatMapMany(provider -> provider.getUserIdByDimensionId(id))).collectList().flatMap(lst -> ClearUserAuthorizationCacheEvent.of((Collection)lst).publish(this.eventPublisher)).then();
    }

    @Transactional
    public Mono<Void> saveDetail(@Nullable Authentication currentAuthentication, Flux<AuthorizationSettingDetail> detailFlux) {
        return detailFlux.flatMap(detail -> ((ReactiveDelete)((ReactiveDelete)this.settingService.getRepository().createDelete().where(AuthorizationSettingEntity::getDimensionType, (Object)detail.getTargetType())).and(AuthorizationSettingEntity::getDimensionTarget, (Object)detail.getTargetId())).execute().thenReturn(detail)).flatMap(detail -> this.addDetail(currentAuthentication, detailFlux)).then();
    }

    @Transactional
    public Mono<Void> addDetail(@Nullable Authentication currentAuthentication, Flux<AuthorizationSettingDetail> detailFlux) {
        return ((Mono)detailFlux.flatMap(detail -> Flux.fromIterable(this.providers).flatMap(provider -> provider.getAllType().filter(type -> type.getId().equals(detail.getTargetType())).singleOrEmpty().flatMap(type -> provider.getDimensionById(type, detail.getTargetId())).flatMapIterable(detail::toEntity)).switchIfEmpty((Publisher)Flux.defer(() -> Flux.fromIterable(detail.toEntity()))).distinct(AuthorizationSettingEntity::getPermission)).map(entity -> null == currentAuthentication ? entity : this.permissionProperties.getFilter().handleSetting(currentAuthentication, entity)).filter(e -> CollectionUtils.isNotEmpty((Collection)e.getActions())).as(arg_0 -> ((DefaultAuthorizationSettingService)this.settingService).save(arg_0))).then();
    }

    @Transactional
    public Mono<Void> deleteDetail(Flux<AuthorizationSettingDetail> detailFlux) {
        return detailFlux.flatMap(detail -> ((ReactiveDelete)((ReactiveDelete)((ReactiveDelete)this.settingService.getRepository().createDelete().where(AuthorizationSettingEntity::getDimensionType, (Object)detail.getTargetType())).and(AuthorizationSettingEntity::getDimensionTarget, (Object)detail.getTargetId())).in(AuthorizationSettingEntity::getPermission, (Collection)detail.getPermissionList().stream().map(AuthorizationSettingDetail.PermissionInfo::getId).collect(Collectors.toList()))).execute()).then();
    }

    public Mono<AuthorizationSettingDetail> getSettingDetail(String targetType, String target) {
        return ((ReactiveQuery)((ReactiveQuery)this.settingService.createQuery().where(AuthorizationSettingEntity::getDimensionTarget, (Object)target)).and(AuthorizationSettingEntity::getDimensionType, (Object)targetType)).fetch().collectList().map(AuthorizationSettingDetail::fromEntity);
    }

    public AuthorizationSettingDetailService(DefaultAuthorizationSettingService settingService, List<DimensionProvider> providers, PermissionProperties permissionProperties, ApplicationEventPublisher eventPublisher) {
        this.settingService = settingService;
        this.providers = providers;
        this.permissionProperties = permissionProperties;
        this.eventPublisher = eventPublisher;
    }
}

