/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.jetlinks.core.Value;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.spi.ServiceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class SpringServiceContext
implements ServiceContext {
    private static final Logger log = LoggerFactory.getLogger(SpringServiceContext.class);
    private final ApplicationContext applicationContext;

    public SpringServiceContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public Optional<Value> getConfig(ConfigKey<String> key) {
        return this.getConfig(key.getKey());
    }

    public Optional<Value> getConfig(String key) {
        return Optional.ofNullable(this.applicationContext.getEnvironment().getProperty(key)).map(Value::simple);
    }

    public <T> Optional<T> getService(Class<T> service) {
        try {
            return Optional.of(this.applicationContext.getBean(service));
        }
        catch (Exception e) {
            log.error("load service [{}] error", service, (Object)e);
            return Optional.empty();
        }
    }

    public <T> Optional<T> getService(String service) {
        try {
            return Optional.of(this.applicationContext.getBean(service));
        }
        catch (Exception e) {
            log.error("load service [{}] error", (Object)service, (Object)e);
            return Optional.empty();
        }
    }

    public <T> List<T> getServices(Class<T> service) {
        try {
            return new ArrayList(this.applicationContext.getBeansOfType(service).values());
        }
        catch (Exception e) {
            log.error("load service [{}] error", service, (Object)e);
            return Collections.emptyList();
        }
    }

    public <T> List<T> getServices(String service) {
        return Collections.emptyList();
    }
}

