/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.protocol;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.jetlinks.community.protocol.RenameProtocolSupport;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.event.EventBus;
import org.jetlinks.supports.protocol.management.ProtocolSupportDefinition;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoader;
import org.jetlinks.supports.protocol.management.ProtocolSupportLoaderProvider;
import reactor.core.publisher.Mono;

@Generated
public class SpringProtocolSupportLoader
implements ProtocolSupportLoader {
    private final Map<String, ProtocolSupportLoaderProvider> providers = new ConcurrentHashMap<String, ProtocolSupportLoaderProvider>();
    private final EventBus eventBus;

    public void register(ProtocolSupportLoaderProvider provider) {
        this.providers.put(provider.getProvider(), provider);
    }

    public Mono<? extends ProtocolSupport> load(ProtocolSupportDefinition definition) {
        return Mono.justOrEmpty((Object)this.providers.get(definition.getProvider())).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("unsupported provider:" + definition.getProvider()))).flatMap(provider -> provider.load(definition)).map(loaded -> new RenameProtocolSupport(definition.getId(), definition.getName(), definition.getDescription(), (ProtocolSupport)loaded, this.eventBus));
    }

    public SpringProtocolSupportLoader(EventBus eventBus) {
        this.eventBus = eventBus;
    }
}

