/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.email.embedded;

import javax.annotation.Nonnull;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.ConfigMetadataConstants;
import org.jetlinks.community.io.file.FileManager;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifierProvider;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.email.EmailProvider;
import org.jetlinks.community.notify.email.embedded.DefaultEmailNotifier;
import org.jetlinks.community.notify.email.embedded.EmailTemplate;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.jetlinks.core.config.ConfigKeyValue;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.FileType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.core.metadata.types.StringType;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DefaultEmailNotifierProvider
implements NotifierProvider,
TemplateProvider {
    private final TemplateManager templateManager;
    private final FileManager fileManager;
    public static final DefaultConfigMetadata templateConfig;
    public static final DefaultConfigMetadata notifierConfig;

    public DefaultEmailNotifierProvider(TemplateManager templateManager, FileManager fileManager) {
        this.templateManager = templateManager;
        this.fileManager = fileManager;
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.email;
    }

    @Nonnull
    public Provider getProvider() {
        return EmailProvider.embedded;
    }

    public ConfigMetadata getNotifierConfigMetadata() {
        return notifierConfig;
    }

    public ConfigMetadata getTemplateConfigMetadata() {
        return templateConfig;
    }

    @Nonnull
    public Mono<DefaultEmailNotifier> createNotifier(@Nonnull NotifierProperties properties) {
        return (Mono)Mono.fromSupplier(() -> new DefaultEmailNotifier(properties, this.templateManager, this.fileManager)).as(LocaleUtils::transform);
    }

    public Mono<EmailTemplate> createTemplate(TemplateProperties properties) {
        return (Mono)Mono.fromSupplier(() -> (EmailTemplate)((EmailTemplate)new EmailTemplate().with(properties)).validate()).as(LocaleUtils::transform);
    }

    static {
        SimplePropertyMetadata name = new SimplePropertyMetadata();
        name.setId("name");
        name.setName("\u6587\u4ef6\u540d");
        name.setValueType((DataType)new StringType());
        SimplePropertyMetadata location = new SimplePropertyMetadata();
        location.setId("location");
        location.setName("\u6587\u4ef6\u5730\u5740");
        location.setValueType((DataType)new FileType().bodyType(FileType.BodyType.url).expand(new ConfigKeyValue[]{ConfigMetadataConstants.allowInput.value((Object)true)}));
        templateConfig = new DefaultConfigMetadata("\u90ae\u4ef6\u6a21\u7248", "").add("subject", "\u6807\u9898", "\u6807\u9898,\u53ef\u4f7f\u7528\u53d8\u91cf", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.maxLength.value((Object)255L)})).add("text", "\u5185\u5bb9", "", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.maxLength.value((Object)5120L), ConfigMetadataConstants.isRichText.value((Object)true)})).add("sendTo", "\u6536\u4ef6\u4eba", "", (DataType)new ArrayType().elementType((DataType)new StringType())).add("attachments", "\u9644\u4ef6\u5217\u8868", "", (DataType)new ArrayType().elementType((DataType)new ObjectType().addPropertyMetadata((PropertyMetadata)name).addPropertyMetadata((PropertyMetadata)location)));
        name = new SimplePropertyMetadata();
        name.setId("name");
        name.setName("\u914d\u7f6e\u540d\u79f0");
        name.setValueType((DataType)new StringType());
        SimplePropertyMetadata value = new SimplePropertyMetadata();
        value.setId("value");
        value.setName("\u914d\u7f6e\u503c");
        value.setValueType((DataType)new StringType());
        SimplePropertyMetadata description = new SimplePropertyMetadata();
        description.setId("description");
        description.setName("\u8bf4\u660e");
        description.setValueType((DataType)new StringType());
        notifierConfig = new DefaultConfigMetadata("\u90ae\u4ef6\u914d\u7f6e", "").add("host", "\u670d\u52a1\u5668\u5730\u5740", "\u4f8b\u5982: pop3.qq.com", (DataType)new StringType().expand(new ConfigKeyValue[]{ConfigMetadataConstants.maxLength.value((Object)255L)})).add("port", "\u7aef\u53e3", "", (DataType)new IntType().min((Number)0).max((Number)65536)).add("sender", "\u53d1\u4ef6\u4eba", "\u9ed8\u8ba4\u548c\u7528\u6237\u540d\u76f8\u540c", (DataType)new StringType()).add("username", "\u7528\u6237\u540d", "", (DataType)new StringType()).add("password", "\u5bc6\u7801", "", (DataType)new PasswordType()).add("properties", "\u5176\u4ed6\u914d\u7f6e", "", (DataType)new ArrayType().elementType((DataType)new ObjectType().addPropertyMetadata((PropertyMetadata)name).addPropertyMetadata((PropertyMetadata)value).addPropertyMetadata((PropertyMetadata)description)));
    }
}

