/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.server.vertx;

import java.util.Collections;
import java.util.Map;
import org.jetlinks.community.network.AbstractServerNetworkConfig;
import org.jetlinks.community.network.resource.NetworkTransport;

public class HttpServerConfig
extends AbstractServerNetworkConfig {
    private int instance = Math.max(4, Runtime.getRuntime().availableProcessors());
    private Map<String, String> httpHeaders;

    public Map<String, String> getHttpHeaders() {
        return this.nullMapHandle(this.httpHeaders);
    }

    private Map<String, String> nullMapHandle(Map<String, String> map) {
        return map == null ? Collections.emptyMap() : map;
    }

    public NetworkTransport getTransport() {
        return NetworkTransport.TCP;
    }

    public String getSchema() {
        return "http";
    }

    public static HttpServerConfigBuilder builder() {
        return new HttpServerConfigBuilder();
    }

    public int getInstance() {
        return this.instance;
    }

    public void setInstance(int instance) {
        this.instance = instance;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public HttpServerConfig(int instance, Map<String, String> httpHeaders) {
        this.instance = instance;
        this.httpHeaders = httpHeaders;
    }

    public HttpServerConfig() {
    }

    public static class HttpServerConfigBuilder {
        private int instance;
        private Map<String, String> httpHeaders;

        HttpServerConfigBuilder() {
        }

        public HttpServerConfigBuilder instance(int instance) {
            this.instance = instance;
            return this;
        }

        public HttpServerConfigBuilder httpHeaders(Map<String, String> httpHeaders) {
            this.httpHeaders = httpHeaders;
            return this;
        }

        public HttpServerConfig build() {
            return new HttpServerConfig(this.instance, this.httpHeaders);
        }

        public String toString() {
            return "HttpServerConfig.HttpServerConfigBuilder(instance=" + this.instance + ", httpHeaders=" + this.httpHeaders + ")";
        }
    }
}

