/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.ComparatorUtils;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.ezorm.core.param.Sort;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.web.api.crud.entity.TermExpressionParser;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.reactor.ql.utils.CompareUtils;
import reactor.core.publisher.Flux;

public class ConverterUtils {
    public static Object tryConvertToList(Object value, Function<Object, Object> converter) {
        List<Object> list = ConverterUtils.convertToList(value, converter);
        if (list.size() == 1) {
            return list.get(0);
        }
        return list;
    }

    public static <T> List<T> convertToList(Object value, Function<Object, T> converter) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (value instanceof String) {
            value = ((String)value).split(",");
        }
        if (value instanceof Object[]) {
            value = Arrays.asList((Object[])value);
        }
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(converter).collect(Collectors.toList());
        }
        return Collections.singletonList(converter.apply(value));
    }

    public static List<Object> convertToList(Object value) {
        return ConverterUtils.convertToList(value, Function.identity());
    }

    public static <T> Flux<T> convertSortedStream(Flux<T> flux, Sort ... sorts) {
        return ConverterUtils.convertSortedStream(flux, Arrays.asList(sorts));
    }

    public static <T> Flux<T> convertSortedStream(Flux<T> flux, Collection<Sort> sorts) {
        if (CollectionUtils.isEmpty(sorts)) {
            return flux;
        }
        ArrayList comparators = new ArrayList(sorts.size());
        for (Sort sort : sorts) {
            String column = sort.getName();
            Comparator comparator = (left, right) -> {
                Object leftVal = ((HashMap)FastBeanCopier.copy((Object)left, new HashMap(), (String[])new String[0])).get(column);
                Object rightVal = ((HashMap)FastBeanCopier.copy((Object)right, new HashMap(), (String[])new String[0])).get(column);
                return CompareUtils.compare(leftVal, rightVal);
            };
            if (sort.getOrder().equalsIgnoreCase("desc")) {
                comparator = comparator.reversed();
            }
            comparators.add(comparator);
        }
        return flux.sort(ComparatorUtils.chainedComparator(comparators));
    }

    public static String[] convertMapToTags(Map<String, Object> map) {
        if (MapUtils.isEmpty(map)) {
            return new String[0];
        }
        String[] tags = new String[map.size() * 2];
        int index = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            String strValue = value instanceof String ? String.valueOf(value) : JSON.toJSONString((Object)value);
            tags[index++] = key;
            tags[index++] = strValue;
        }
        if (tags.length > index) {
            return Arrays.copyOf(tags, index);
        }
        return tags;
    }

    public static List<Term> convertTerms(Object value) {
        if (value instanceof String) {
            String strVal = String.valueOf(value);
            if (strVal.startsWith("[")) {
                value = JSON.parseArray((String)strVal);
            } else {
                return TermExpressionParser.parse((String)strVal);
            }
        }
        if (value instanceof List) {
            return new JSONArray((List)value).toJavaList(Term.class);
        }
        throw new UnsupportedOperationException("unsupported term value:" + value);
    }
}

